<?php
class Slideshow_model extends Model {

    function Slideshow_model()
    {
        parent::Model();
    }
    //--------------------------------------------------------------------------
    function getById($id)
    {
        $result = null;

        $this->db->select('*');
        $this->db->where('id',$id);
        $this->db->from('slideshows');
        $db_result = $this->db->get();

        if ($db_result->num_rows() == 1)
        {
            $result             = (array)$db_result->row();
            $result['slides']   = $this->getSlidesBySlideshowId($id);
        }
        return $result;
    }
    //--------------------------------------------------------------------------
    function getAll()
    {
        $result = null;

        $this->db->select('*');
        $this->db->from('slideshows');
        $db_result = $this->db->get();

        $result =  $db_result->result_array();
        if(!empty($result) && is_array($result))
        {
            foreach($result as $k=>$v)
            {
                $result[$k]['slides'] = $this->getSlidesBySlideshowId($v['id']);
            }
        }
        return $result;
    }

    //--------------------------------------------------------------------------
    function create($slideshow)
    {
        if($this->db->insert('slideshows', $slideshow))
            return $this->db->insert_id();
        else
            return false;
    }
    //--------------------------------------------------------------------------
    function update($id,$slideshow)
    {
                $this->db->where('id', $id);
        return  $this->db->update('slideshows', $slideshow);
    }

    //--------------------------------------------------------------------------
    function delete($id)
    {
        $slideshow = $this->getById($id);
        if(!empty($slideshow['images']) && is_array($slideshow['images']))
        {
            foreach($slideshow['slides'] as $k=>$v)
            {
                $this->delete_image($v['id']);
            }
        }

        $this->db->where('id', $id);
        $this->db->delete('slideshows');     
        return ($this->db->affected_rows() > 0);
    }

    //images
    //--------------------------------------------------------------------------
    function getSlideById($id)
    {
        $this->db->select('*');
        $this->db->where('id',$id);
        $this->db->from('slideshow_slides');
        $db_result = $this->db->get();

        if ($db_result->num_rows() == 1)
            return (array)$db_result->row();
    }
    //--------------------------------------------------------------------------
    function getSlidesBySlideshowId($slideshowId)
    {
        $this->db->select('*');
        $this->db->where('slideshow_id',$slideshowId);
        $this->db->from('slideshow_slides');
        $this->db->order_by('order','desc');
        
        $db_result = $this->db->get();
        return $db_result->result_array();
    }
    //--------------------------------------------------------------------------
    function createSlide($image)
    {
        if($this->db->insert('slideshow_slides', $image))
            return $this->db->insert_id();
        else
            return false;
    }
    //--------------------------------------------------------------------------
    function updateSlide($id,$image_modifications)
    {
        $result = true;
        try
        {
            $slide  = $this->getSlideById($id);
            //1 jesli file_path = null to usun stare zjdeicie
            if(isset($slide['file_path']) && file_exists($slide['file_path']) && !isset($image_modifications['file_path']))
                unlink($slide['file_path']);
            //jesli zdjecie stare != zdjecie nowe to usun stare
            else if(isset($slide['file_path']) && file_exists($slide['file_path']) && isset($image_modifications['file_path']) && $image_modifications['file_path'] != $slide['file_path'])
                unlink($slide['file_path']);


            $this->db->where('id', $id);
            $result =  $this->db->update('slideshow_slides', $image_modifications);
        }
        catch(Exception $e)
        {
            $result = false;
        }
        return $result;
    }
    //--------------------------------------------------------------------------
    function updateMultipleSlides($slides)
    {
        $result = true;
        if(is_array($slides))
        {
            $this->db->trans_begin();
                try
                {
                    foreach($slides as $k=>$v)
                    {
                        $this->db->where('id', $v['id']);
                        $this->db->update('slideshow_slides', $v);
                    }
                }
                catch(Exception $e)
                {
                    $result = false;
                }

            if ($this->db->trans_status() === FALSE)
            {
                $this->db->trans_rollback();
            }
            else
            {
                $this->db->trans_commit();
                $result = true;
            }
        }
        return $result;
    }
    //--------------------------------------------------------------------------
    function deleteSlide($id)
    {
        $result = true;
        try
        {
            $slide  = $this->getSlideById($id);
            if(!empty($slide))
            {
                if(!empty($slide['file_path']) && file_exists('.'.$slide['file_path']))
                    unlink('.'.$slide['file_path']);

		$this->db->where('id', $id);
		$this->db->delete('slideshow_slides');
            }
            else
                throw new Exception('Nie pobrano wskazanego zdjęcia');
        }
        catch(Exception $e)
        {
            $result = false;
        }
        return $result;
    }
    //--------------------------------------------------------------------------
}
?>
