<?php
//MODEL DO ZARZADZANIA ZDEFINIOWANYMI USTAWIENIAMI
//POLE NAME KAZDEGO REKORDU TABELI SETTINGS MUSI BYC UNIKALNE

class Settings_model extends Model
{
    private $_types = Array('TEXT','TEXTAREA','WYSIWYG');

    function Settings_model()
    {
        parent::Model();
    }

    //--------------------------------------------------------------------------
    public function create($setting, $setting_lang)
    {
        $result = false;
        if(is_array($setting) && is_array($setting_lang))
        {
            $this->db->trans_begin();
                try
                {
                    $setting_id = null;
                    $this->db->insert('settings',$setting);
                    
                    $setting_id = $this->db->insert_id();
                    $setting_lang['setting_id'] =   $setting_id;
                    $this->db->insert('setting_languages',$setting_lang);
                    
                }
                catch(Exception $e)
                {
                    $result = false;
                }

            if ($this->db->trans_status() === FALSE)
            {
                $this->db->trans_rollback();
                $result = true;
            }
            else
            {
                $this->db->trans_commit();
                $result = true;
            }
        }
        return $result;        
    }
    //--------------------------------------------------------------------------
    public function createLanguage($setting_language)
    {
        if($this->db->insert('setting_languages', $setting_language))
            return $this->db->insert_id();
        else
            return false;
    }
    //--------------------------------------------------------------------------
    public function getTypes()
    {
        return $this->_types;
    }
    //--------------------------------------------------------------------------
    //zwraca liste kategorii ustawień
    public function getCategories()
    {
        $result = null;

        $this->db->select('*');
        $this->db->from('setting_categories');

            $db_result =  $this->db->get();
            $db_result = $db_result->result_array();

            if(!empty($db_result) && is_array($db_result))
            {
                foreach($db_result as $k=>$v)
                {
                    $result[] = $v;
                }
            }

        return $result;
    }
    //--------------------------------------------------------------------------
    //zrwaca dane kategorii ustawień
    public function getCategory($id)
    {
        $result = null;

        $this->db->select('*');
        $this->db->where('id',$id);
        $this->db->from('setting_categories');
        $db_result = $this->db->get();

        if ($db_result->num_rows() == 1)
        {
            $result = (array)$db_result->row();
        }
        return $result;
    }
    //--------------------------------------------------------------------------
    //zrwaca dane ustawienia
    public function getById($id)
    {
        $result = null;

        $this->db->select('*');
        $this->db->where('id',$id);
        $this->db->from('settings');
        $db_result = $this->db->get();

        if ($db_result->num_rows() == 1)
        {
            $result = (array)$db_result->row();
        }
        return $result;
    }
    //--------------------------------------------------------------------------
    //zwraca wszystkie ustawienia pogrupowane w kategoriach
    function getAllByLang($langId)
    {
        $result = array();
        $result = $this->getCategories();
        if(!empty($result) && is_array($result))        
        {
            foreach($result as $k=>$v)
            {
                $result[$k]['settings'] = $this->getByCategoryId($v['id'],$langId);
            }
        }
        return $result;
    }
    //--------------------------------------------------------------------------
    function getAllAsDictionary($lang_id)
    {
        $result   = null;
        $general_grouped_settings   = $this->getAllByLang(null);
        $lang_grouped_settings      = $this->getAllByLang($lang_id);

        
        if(!empty($general_grouped_settings) && is_array($general_grouped_settings))
            foreach($general_grouped_settings as $k=>$v)
            {

                //$result[$v['name']] = array($v['settings']['name'] => $v['settings']['value']);
                $result[$v['name']] = null;
                
                if(!empty($v['settings']))
                    foreach($v['settings'] as $kk=>$vv)
                        $result[$v['name']][$vv['name']]  = $vv['value'];
            }

        if(!empty($lang_grouped_settings) && is_array($lang_grouped_settings))
            foreach($lang_grouped_settings as $k=>$v)            {


                if(!empty($v['settings']))
                    foreach($v['settings'] as $kk=>$vv)
                        $result[$v['name']][$vv['name']]  = $vv['value'];
            }

        return $result;
    }
    //--------------------------------------------------------------------------
    //zwraca ustawienia danej kategorii
    function getByCategoryId($id,$langId)
    {
        $id = (int)$id;

        $result = null;
        $langId = (int)$langId;
        if($langId == 0)
            $langId = null;

        /*
        $this->db->select('*');       
        $this->db->from('settings');
        $this->db->join('setting_languages','settings.id=setting_languages.setting_id');
        $this->db->where('category_id',$id);
        $this->db->where('lang_id',$langId);
        $this->db->order_by('order','desc');
        $db_result =  $this->db->get();
         */

            $db_result = null;
            if(!is_null($langId))
            {
                $db_result =  $this->db->query('SELECT s.*, sl.*, (SELECT GROUP_CONCAT(CAST(sl1.lang_id AS CHAR)) FROM setting_languages sl1 WHERE sl1.setting_id = sl.setting_id) AS langs
                                                FROM settings AS s JOIN  setting_languages AS sl ON sl.setting_id = s.id
                                                WHERE s.category_id = '.$id.' AND sl.lang_id = '.$langId.' ORDER BY s.order DESC');
            }
            else
                $db_result =  $this->db->query('SELECT s.*, sl.*, (SELECT GROUP_CONCAT(CAST(sl1.lang_id AS CHAR)) FROM setting_languages sl1 WHERE sl1.setting_id = sl.setting_id) AS langs
                                                FROM settings AS s JOIN  setting_languages AS sl ON sl.setting_id = s.id
                                                WHERE s.category_id = '.$id.' AND sl.lang_id IS NULL ORDER BY s.order DESC');            {

            }
            
            $result =  $db_result->result_array();

       
        return $result;
    }
    //--------------------------------------------------------------------------
    //aktualizacji wartości ustawień
    //slownik ktorego index wskazuje na name pola a wartosc na wartosc tego pola
    function update($dictionary,$lang_id)
    {
        $result = true;
        try
        {
            if(!empty($dictionary) && is_array($dictionary))
            {
                foreach($dictionary as $key=>$value)
                {
                    $this->db->where('id', $key);
                    
                    $data['value'] = $value;
                    if(!$this->db->update('setting_languages', $data))
                        throwException ('error');

                }
            }
        }
        catch(Exception $e)
        {
            $result = false;
        }
        return $result;
    }
    //--------------------------------------------------------------------------
    function delete($id)
    {
        $result = false;

            $this->db->trans_begin();
            try
            {
                $this->db->where('setting_id', $id);
                $this->db->delete('setting_languages');

                $this->db->where('id', $id);
                $this->db->delete('settings');
            }
            catch(Exception $e)
            {
                $result = false;
            }

            if ($this->db->trans_status() === FALSE)
            {
                $this->db->trans_rollback();
                $result = true;
            }
            else
            {
                $this->db->trans_commit();
                $result = true;
            }
        return $result;        
    }
    //--------------------------------------------------------------------------
}
?>
