<?php
define('MENU_MODEL_DEFAULT_MENU_ITEM_CLASS', '');
define('MENU_MODEL_SELECTED_MENU_ITEM_CLASS', 'active corner');

// MODEL DO GENEROWANIA GLOWNEGO MENU STRONY
class Menu_model extends Model
{

    //--------------------------------------------------------------------------
    function Menu_model()
    {
        parent::Model();
    }
    //--------------------------------------------------------------------------
    private function get_active_langs()
    {
        $this->db->where('active',1);
        $db_result = $this->db->get('languages');
        return $db_result->result_array();
    }
    //--------------------------------------------------------------------------
    private function get_lang_by_id($lang_id)
    {
        $this->db->where('idlanguages',$lang_id);
        $db_result = $this->db->get('languages');  
        
        if ($db_result->num_rows() == 1) return (array)$db_result->row();
        return NULL;                
    }
    //--------------------------------------------------------------------------
    function get_with_element_included_on_first_fevel($menu_id,$lang, $i18n, $selected_id,$selected_type,$root=false)
    {
        $result = null;
        if(empty($root))
        {
            $menu = $this->getById($menu_id, $lang, $i18n,$selected_id,$selected_type);
            if(!empty($menu))
            {
                foreach($menu as $k=>$v)
                {
                    if(($v['idelement'] == $selected_id) && ($v['type']==$selected_type))
                    {
                        return $menu;
                    }
                    else if(!empty($v['children']))
                    {
                        $tmp = $this->get_with_element_included_on_first_fevel($menu_id,$lang, $i18n, $selected_id,$selected_type,$v);
                        if(!empty($tmp))
                            return $tmp;
                    }
                }
            }
        }
        else
        {
            if(is_array($root))
                foreach($root as $k=>$v)
                {
                    if(($v['idelement'] == $selected_id) && ($v['type']==$selected_type))
                    {
                        return $root;
                    }
                    else if(!empty($v['children']))
                    {
                        return $this->get_with_element_included_on_first_fevel($menu_id,$lang, $i18n, $selected_id,$selected_type,$v);
                        
                    }
                }
        }
        return $result;
    }
    //--------------------------------------------------------------------------
    //generuje strukture menu do renderowania w widoku 
    function getById($id, $lang, $i18n, $selected_id=null,$selected_type=null)
    {
        $result = null;
        $menu_items = $this->get_menu_by_id($id,$lang);

        foreach($menu_items as $k=>$v)
        {


                if(!empty($selected_id) && !empty($selected_type) && ($v['idelement'] == $selected_id) && ($v['type']==$selected_type))
                {
                        $v['selected'] = true;


                        if(!empty($parent))
                        {
                                $parent['selected'] = true;
                        }
                }
                else
                        $v['selected'] = false;

                $v['children']	= $this->get_menu_subitems($v['idmenu_items'],$menu_items,$selected_id,$selected_type);

                //jeśli są elementy podmenu i dowolne z nich selected to parent tez selected
                if(!empty($v['children']) && count($v['children']) > 0)
                        foreach($v['children'] as $kk=>$vv)
                                if($vv['selected'])
                                {
                                        $v['selected'] = true;
                                        break;
                                }

                if(empty($v['idparent']))
                {
                        $result[] = $v;
                }

        }

        if(!empty($result) && is_array($result))
            foreach($result as $k=>$v)
            {
                $result[$k]['class'] = ($result[$k]['selected'] == true) ? MENU_MODEL_SELECTED_MENU_ITEM_CLASS: MENU_MODEL_DEFAULT_MENU_ITEM_CLASS;
                $result[$k]['link']  = $this->getLink($v['idmenu_item_types'],$lang,$v['friendlyurl'],$v['idelement'],$i18n);
            }
        
        return $result;
    }
    //--------------------------------------------------------------------------
    private function get_menu_by_id($id, $idlang){
            $this->db->select('*, menu_item_languages.friendlyurl as mi_url');
            $this->db->from('menu_item_types');
            $this->db->join('menu_items', 'menu_items.idmenu_item_types = menu_item_types.idmenu_item_types');
            $this->db->join('menu_item_languages', 'menu_item_languages.idmenu_items = menu_items.idmenu_items');
            $this->db->where('menu_item_languages.idlanguages',$idlang);

            $this->db->where('menu_items.idmenus',$id);
            $this->db->order_by('showorder','desc');
            $result = $this->db->get();
            return $result->result_array();
    }
    //--------------------------------------------------------------------------
    private function get_menu_subitems($parent_id,&$menu_items,$selected_id=null,$selected_type=null)
    {
        $result = null;
        foreach($menu_items as $k=>$v)
        {

                if(!empty($selected_id) && !empty($selected_type) && ($v['idelement'] == $selected_id) && ($v['type']==$selected_type))
                        $v['selected'] = true;
                else
                        $v['selected'] = false;

                if($v['idparent'] == $parent_id)
                {
                        $result[$k] = $v;
                        $result[$k]['children'] = $this->get_menu_subitems($v['idmenu_items'],$menu_items,$selected_id,$selected_type);
                }
        }
        return $result;
    }
    //--------------------------------------------------------------------------
    private function getLink($type_id,$langId,$friendlyurl,$id,$i18n)
    {
        $result = '';

        try
        {
            $pos = strpos($friendlyurl,'http');
            if($pos === false)
            {
                $lang   = $this->get_lang_by_id($langId);
                $result .= $friendlyurl.'-'.$type_id.'-'.$langId;

                if(!empty($id))
                    $result .= '-'.$id;
                
                $result .= '.html';
            }
            else
                $result = $friendlyurl;
        }
        catch(Exception $e)
        {
            $result = NULL;
        }
        return $result;
    }
    //--------------------------------------------------------------------------
}
?>
