<?php
class Frontside_model extends Model{
		function Frontside_model()
	    {
	        parent::Model();
	    }

	    //pobranie ksiegi gosci
	    function get_all_guests()
	    {
	    	$this->db->select('*');
			$this->db->from('guest_book');
			$this->db->orderby('id desc');
			$this->db->limit('30');
			$result = $this->db->get();
			return $result->result_array();
	    }

	    //ddoaj wpis do skiegi gosci
	    function add_guest($t, $txt)
	    {
	    	$data['title'] = $t;
	    	$data['text'] = $txt;
	    	$data['date'] = date('Y.m.d H:m:s');
	    	$this->db->insert('guest_book', $data);
	    }

	    //funkcja zwracajaca id artykolow z danego menu

	    function get_article_from_menu($id=null)
	    {
	    	$this->db->select('idelement');
	    	$this->db->from('menu_items');
	    	$this->db->where('idmenus', $id);
	    	$result = $this->db->get();
			$ret = $result->result_array();

			$return = array();

			foreach($ret as $r)
			{
				$return[]=$r['idelement'];
			}

			return $return;
	    }

 		//sprawdza ile jest nadrzednych elementow w meny
	    function get_count_main_article_from_menu($id=null)
	    {
	    	$this->db->select('count(idelement) parents');
	    	$this->db->from('menu_items');
	    	$this->db->where('idmenus', $id);
	    	$this->db->where('idparent', null);
	    	$result = $this->db->get();
			return $result->result_array();
	    }

		//pobiera wszystkie artykuły dla wybranego języka($idlang), kolejność po showorder
		function get_articles($idlang){
			$this->db->select('articles.*, article_languages.*');
			$this->db->from('articles');
			$this->db->join('article_languages', 'articles.idarticles = article_languages.idarticles');
			$this->db->where('idlanguages',$idlang);
			$this->db->where('active', true);
			$this->db->order_by('showorder', 'desc');
			$this->db->order_by('date', 'desc');
			$result = $this->db->get();
			return $result->result_array();
		}

		function get_articles_by_parent_id($parent_id, $idlang){
			$this->db->select('articles.*, article_languages.*');
			$this->db->from('articles');
			$this->db->join('article_languages', 'articles.idarticles = article_languages.idarticles');
                        $this->db->where('idparent',$parent_id);
			$this->db->where('idlanguages',$idlang);
			$this->db->where('active', true);
			$this->db->order_by('showorder', 'desc');
			$this->db->order_by('date', 'desc');
			$result = $this->db->get();
			return $result->result_array();
		}

		//pobiera artykuł po id, kolejność po showorder
		function get_article($id, $idlang = null){
			$this->db->select('*');
			$this->db->from('articles');
			$this->db->join('article_languages', 'article_languages.idarticles = articles.idarticles');
			$this->db->join('languages', 'article_languages.idlanguages = languages.idlanguages');
			$this->db->where('articles.idarticles',$id);
			if($idlang != null){
				$this->db->where('languages.idlanguages',$idlang);
			}
			$result = $this->db->get();
			return $result->result_array();
		}

                function get_first_article($idlang = null)
                {
                                $this->db->select('*');
                                $this->db->from('articles');
                                $this->db->join('article_languages', 'article_languages.idarticles = articles.idarticles');
                                $this->db->join('languages', 'article_languages.idlanguages = languages.idlanguages');
                                if($idlang != null){
                                        $this->db->where('languages.idlanguages',$idlang);
                                }
                                $this->db->where('articles.idparent IS NULL',NULL, FALSE);
                                $this->db->order_by('articles.showorder desc');
                                $this->db->order_by('articles.date', 'asc');


                                $result = $this->db->get();

                    if ($result->num_rows() > 0) return $result->row();
                    return NULL;
                }

		function get_projects($idparent, $date, $idlang){
			$this->db->select('*');
			$this->db->from('articles');
			$this->db->join('article_languages', 'article_languages.idarticles = articles.idarticles');
			$this->db->where('articles.idparent',$idparent);
			$this->db->where('idlanguages',$idlang);
			$this->db->where('additional_data >=',$date);
			$this->db->order_by('additional_data', 'asc');
			$result = $this->db->get();
			return $result->result_array();
		}

		function get_subarticles($idparent, $idlang, $tree = false, $level = null)
                {
                    $result = null;

			$this->db->select('*');
			$this->db->from('articles');
			$this->db->join('article_languages', 'article_languages.idarticles = articles.idarticles');
			$this->db->where('articles.idparent',$idparent);
			$this->db->where('idlanguages',$idlang);
			$this->db->order_by('additional_data', 'asc');
			$dbresult = $this->db->get();

			$result =  $dbresult->result_array();
                        if($tree)
                        {
                            if(!empty($result) && is_array($result))
                                foreach($result as $k=>$v)
                                {
                                    $v['level'] = $level;

                                    if(!is_null($v['idparent']))
                                        $result[$k]['children'] = $this->get_subarticles($v['idarticles'],$idlang, true,($level+1));
                                }
                        }
                            return $result;

		}

                function get_top_parent_for_child_article($child_article_id, $lang_id)
                {
                    $article = $this->get_article($child_article_id, $lang_id);
                    if(!empty($article[0]['idparent']))
                        return $this->get_top_parent_for_child_article($article[0]['idparent'], $lang_id);
                    elseif(!empty($article[0]))
                        return $article[0];
                    else
                        return null;
                }
                function get_articles_tree($idlang,$idparent=null)
                {
                    $result = null;

			$this->db->select('*');
			$this->db->from('articles');
			$this->db->join('article_languages', 'article_languages.idarticles = articles.idarticles');
			$this->db->where('articles.idparent',$idparent);
			$this->db->where('idlanguages',$idlang);
			$this->db->order_by('additional_data', 'asc');
			$result = $this->db->get();
			$result = $result->result_array();

                    if(!empty($result) && is_array($result))
                    {
                        foreach($result as $k=>$v)
                        {
                            $v['level'] = 0;

                            if(!empty($v['idparent']))
                            {
                                $result[$k]['children'] = $this->get_subarticles($v['idarticles'], $idlang,true, 1);
                            }
                        }
                    }
                    return $result;
                }

		//pobiera wszystkie newsy dla wybranego języka($idlang), kolejność po showorder
		function get_newses($idlang,$limit=0){
			$this->db->select('newses.idnewses, newses.date, name,title,content, shortdesc, friendlyurl, image');
			$this->db->from('newses');
			$this->db->join('news_languages', 'newses.idnewses = news_languages.idnewses');
			$this->db->where('idlanguages',$idlang);
			$this->db->where('active', true);
			$this->db->order_by('showorder', 'desc');
			$this->db->order_by('date', 'desc');

			//dodanie limitu do newsow
			if($limit > 0)
			{
				$this->db->limit($limit);
			}

			$result = $this->db->get();
			return $result->result_array();
		}

		//pobiera news po id, kolejność po showorder
		function get_news($id, $idlang){
			$this->db->select('*');
			$this->db->from('newses');
			$this->db->join('news_languages', 'news_languages.idnewses = newses.idnewses');
			$this->db->where('newses.idnewses',$id);
			$this->db->where('idlanguages',$idlang);
			$result = $this->db->get();
			//return $result->result_array();
                        if ($result->num_rows() == 1)
                            return (array)$result->row();
                        else
                            null;
		}

		function get_galleries($idlang){
			$this->db->select('galleries.*, galleries_languages.*, languages.fullname, languages.shortname');
			$this->db->from('galleries');
			$this->db->join('galleries_languages', 'galleries.idgalleries = galleries_languages.idgalleries');
			$this->db->join('languages', 'languages.idlanguages = galleries_languages.idlanguages');
			$this->db->where('languages.idlanguages', $idlang);
			$this->db->order_by('showorder');
			$result = $this->db->get();
			return $result->result_array();
		}

		function get_galleries_by_category_id($category_id,$idlang){
			$this->db->select('galleries.*, galleries_languages.*, languages.fullname, languages.shortname');
			$this->db->from('galleries');
			$this->db->join('galleries_languages', 'galleries.idgalleries = galleries_languages.idgalleries');
			$this->db->join('languages', 'languages.idlanguages = galleries_languages.idlanguages');
			$this->db->where('languages.idlanguages', $idlang);
                        $this->db->where('galleries.idcategory', $category_id);
			$this->db->order_by('showorder');
			$result = $this->db->get();
			return $result->result_array();
		}

        //pobiera pierwszą galerie z listy
        function get_first_gallery($idlang)
        {
			$this->db->select('*');
			$this->db->from('galleries_languages');
			$this->db->join('galleries', 'galleries.idgalleries = galleries_languages.idgalleries');
			$this->db->where('galleries_languages.idlanguages',$idlang);
			$this->db->order_by('showorder', 'desc');
			$result = $this->db->get();
			$tmp = $result->result_array();
            if(is_array($tmp) && !empty($tmp))
                return $tmp[0];
            else
                return null;
        }
		//pobiera wszystkie info o danej galerii dla wybranego języka($idlang) i listę fotek dla niej, kolejność po showorder
		function get_gallery_by_id($id,$idlang){
			$this->db->select('galleries_languages.name, galleries_languages.title, galleries_languages.keywords, galleries_languages.shortdesc, galleries_languages.abstract, galleries_languages.subject, galleries_languages.topic, galleries_languages.copyrights, galleries.idparent, galleries.active');
			$this->db->from('galleries_languages');
			$this->db->join('galleries', 'galleries.idgalleries = galleries_languages.idgalleries');
			$this->db->where('galleries_languages.idlanguages',$idlang);
			$this->db->where('galleries_languages.idgalleries',$id);
			$this->db->order_by('showorder', 'asc');
			$result = $this->db->get();
			return $result->result_array();
		}

		function get_gallery($id){
			$this->db->select('languages.shortname, galleries.idgalleries, galleries_languages.title, galleries_languages.friendlyurl');
			$this->db->from('galleries_languages');
			$this->db->join('galleries', 'galleries.idgalleries = galleries_languages.idgalleries');
			$this->db->join('languages', 'languages.idlanguages = galleries_languages.idlanguages');
			$this->db->where('galleries_languages.idgalleries',$id);
			$result = $this->db->get();
			return $result->result_array();
		}

		//pobiera wszystkie obrazki dla wybranego języka($idlang), kolejność po showorder
		function get_gallery_images($id,$idlang){
			$this->db->select('*');
			$this->db->from('images');
			$this->db->join('images_languages', 'images_languages.idimages = images.idimages');
			$this->db->where('images_languages.idlanguages',$idlang);
			$this->db->where('images.idgalleries',$id);
  			$this->db->order_by('images.showorder','desc');
                        $this->db->order_by('images.idimages','asc');
			$result = $this->db->get();
			return $result->result_array();
		}

		//pobiera wszystkie info o danego obrazka dla wybranego języka($idlang), kolejność po showorder
		function get_image_by_id($id,$idlang){
			$this->db->select('*');
			$this->db->from('images');
			$this->db->join('images_languages', 'images_languages.idimages = images.idimages');
			$this->db->where('images_languages.idlanguages',$idlang);
			$this->db->where('images_languages.idimages',$id);
			$this->db->order_by('showorder', 'asc');
			$result = $this->db->get();
			return $result->result_array();
		}

		//pobiera standardowe metatagi dla danego typu(artykul, news, itd)($type) dla danego języka($idlang)
		function get_default_metatags($type, $idlang){
			$this->db->select('*');
			$this->db->from('metatags');
			$this->db->join('metatag_types', 'metatag_types.idmetatag_types = metatags.idmetatag_types');
			$this->db->where('metatags.idlanguages',$idlang);
			$this->db->where('metatag_types.name',$type);
			$result = $this->db->get();
			return $result->result_array();
		}

		function get_menu_by_id($id, $idlang){
			$this->db->select('*,menu_item_languages.friendlyurl as mi_url');
			$this->db->from('menu_item_types');
			$this->db->join('menu_items', 'menu_items.idmenu_item_types = menu_item_types.idmenu_item_types');
			$this->db->join('menu_item_languages', 'menu_item_languages.idmenu_items = menu_items.idmenu_items');
			$this->db->where('menu_item_languages.idlanguages',$idlang);
			$this->db->where('menu_items.idmenus',$id);
			$this->db->order_by('showorder','desc');
			$result = $this->db->get();
			return $result->result_array();
		}

		function get_language($id){
			$this->db->select('*');
			$this->db->from('languages');
			$this->db->where('idlanguages',$id);
			$result = $this->db->get();
			return $result->result_array();
		}

		function get_active_languages(){
			$this->db->select('*');
			$this->db->from('languages');
			$this->db->where('active', true);
			$result = $this->db->get();
			return $result->result_array();
		}

		function get_product($id, $idlang){
			$this->db->select('*');
			$this->db->from('products');
			$this->db->join('products_languages', 'products_languages.idproducts = products.idproducts');
			$this->db->where('products.idproducts',$id);
			$this->db->where('idlanguages',$idlang);
			$result = $this->db->get();
			return $result->result_array();
		}

		function get_products_by_cat($id, $idlang){
			$this->db->select('*');
			$this->db->from('products');
			$this->db->join('products_languages', 'products_languages.idproducts = products.idproducts');
			$this->db->join('product_product_categories', 'product_product_categories.idproducts = products.idproducts');
			$this->db->where('product_product_categories.idproduct_categories',$id);
			$this->db->where('idlanguages',$idlang);
			$result = $this->db->get();
			return $result->result_array();
		}

		function get_subproducts($id, $idlang){
			$this->db->select('*');
			$this->db->from('products');
			$this->db->join('products_languages', 'products_languages.idproducts = products.idproducts');
			$this->db->join('subproducts', 'subproducts.idchild = products.idproducts');
			$this->db->where('subproducts.idparent',$id);
			$this->db->where('idlanguages',$idlang);
			$result = $this->db->get();
			return $result->result_array();
		}

		function get_complet($parent, $child){
			$this->db->select('*');
			$this->db->from('subproducts');
			$this->db->where('idparent',$parent);
			$this->db->where('idchild',$child);
			$result = $this->db->get();
			return $result->result_array();
		}

		function get_product_category($id, $idlang=null){
			$this->db->select('*');
			$this->db->from('product_categories');
			$this->db->join('product_categories_languages', 'product_categories_languages.idproduct_categories = product_categories.idproduct_categories');
			$this->db->join('languages', 'product_categories_languages.idlanguages = languages.idlanguages');
			$this->db->where('product_categories.idproduct_categories',$id);
			if($idlang!=null){
				$this->db->where('languages.idlanguages',$idlang);
			}
			$result = $this->db->get();
			return $result->result_array();
		}

		function get_images_by_idgallery($id,$langid=3)
                {
			$this->db->select('*');
			$this->db->from('images');
                        $this->db->join('images_languages','images.idimages = images_languages.idimages');
			$this->db->where('images.idgalleries',$id);
                        $this->db->where('images_languages.idlanguages',$langid);
			$this->db->where('active',true);
			$this->db->order_by('images.showorder');
			$result = $this->db->get();
			return $result->result_array();
		}

		function get_product_language($id){
			$this->db->select('languages.shortname, product_categories_languages.friendlyurl as cat_url, products_languages.*, product_categories_languages.idlanguages as idlang');
			$this->db->from('languages');
			$this->db->join('products_languages', 'products_languages.idlanguages = languages.idlanguages');
			$this->db->join('products', 'products_languages.idproducts = products.idproducts');
			$this->db->join('product_product_categories', 'product_product_categories.idproducts = products.idproducts');
			$this->db->join('product_categories', 'product_categories.idproduct_categories = product_product_categories.idproduct_categories');
			$this->db->join('product_categories_languages', 'product_categories_languages.idproduct_categories = product_categories.idproduct_categories');
			$this->db->where('products.idproducts', $id);
			$this->db->having('products_languages.idlanguages = idlang');
			$result = $this->db->get();
			return $result->result_array();
		}


        function get_gallerypage_slideshow_images()
        {
            $sciezka = "files/img/slideshow/gallery/";
            $lista=array();
            @$katalog = opendir($sciezka);
            if($katalog)
            {
                while ($plik = strtolower(readdir($katalog))) {
                    if (($plik<>".")&&($plik<>"..")) if(!is_dir($sciezka.$plik))
                        $lista[]= "/".$sciezka.$plik;
                }
                closedir($katalog);
            }
            return $lista;
        }
	}

?>