<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

//BIBLBIOTEKA : CMS
//OPIS: udostepnienie metod wspolnych dla calego cms-a

class Cms {
    
    protected $ci;
    private   $localization;
    private   $smtp;
    
    //--------------------------------------------------------------------------
    function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->config->load('localization');
        $this->ci->config->load('smtp');

        $this->localization = $this->ci->config->item('PL');
        $this->smtp         = $this->ci->config->item('smtp');

        $this->ci->load->library('session');
        $this->ci->load->library('auth');
        $this->ci->load->database();
        $this->ci->load->model('admin_model');
    }
    //----------------------------------------------------------------------
    private function get_language($idlang){
            $lang = $this->ci->admin_model->get_language_by_id($idlang);
            if(isset($lang[0])){
                    $lang = (array)$lang[0];
            }else{
                    $lang = null;
            }
            return $lang;
    }
    //----------------------------------------------------------------------
    private function set_language($idlang)
    {
            $lang                               = $this->get_language($idlang);
            
            
            if(!empty($lang['shortname']))
            {
                $this->localization                 = $this->ci->config->item($lang['shortname']);
                $this->localization['meta_data']    = $lang;
            }
    }
    //--------------------------------------------------------------------------
    //ustawia jezyk i zwraca obiekt localization
    public function get_localization($idlang)
    {
        $this->set_language($idlang);
        return $this->localization;
    }
    //--------------------------------------------------------------------------
    public function generateFriendlyUrl($target_name){
        
        $url_config = $this->ci->config->item('url');
        $result     = url_title($target_name, 'dash', TRUE);
        return $result;
    }
    //--------------------------------------------------------------------------
    public function getMenus($layout = 'empty', $data=''){
            $idgroup    = $this->ci->auth->getGroupId(); //$this->session->userdata('idgroups');
            $result     = '';

            if($idgroup != null){
                    $result['menu_poziom']  = $this->generateMenuHorizontal($idgroup);
                    $result['menu_pion']    = $this->ci->load->view('_shared/elements/cms/menus/menu_pion/'.$layout, $data, true);
            }
            return $result;
    }
    //--------------------------------------------------------------------------
    private function generateMenuHorizontal($idgroup){
            $data['elements']   = $this->ci->admin_model->get_elements_for_group($idgroup);
            $content            = $this->ci->load->view('_shared/elements/cms/menus/menu_poziom', $data, true);


            if($this->ci->auth->hasAccess('rights'))
                $data['content'] = $content;
            else
                $data['content'] = '';

            return $content;
    }
    //--------------------------------------------------------------------------
    function uploadFile($index,$custom_config=null)
    {
        $result = null;
        
        //default_config
        $config['upload_path']      = './files/uploads/';
        $config['allowed_types']    = 'gif|jpg|png';
        $config['remove_spaces']    = true;
        $config['max_size']         = '500';
        $config['max_width']        = '1024';
        $config['max_height']       = '768';

        if(!empty($custom_config) && is_array($custom_config))
        {
            foreach($custom_config as $k=>$v)
            {
                $config[$k] = $v;
            }
        }

        $this->ci->load->library('upload', $config);
        if(!$this->ci->upload->do_upload($index))
        {
            $result = array('error' => $this->ci->upload->display_errors());
        }
        else
        {
            $result = array('upload_data' => $this->ci->upload->data());
        }

        return $result;
    }
    //--------------------------------------------------------------------------
    //usunięcie całego katalogu razem z potomkami, potrzebne w galeriach
    function full_rmdir($dirname){
        if ($dirHandle = opendir($dirname)){
            $old_cwd = getcwd();
            chdir($dirname);

            while ($file = readdir($dirHandle)){
                if ($file == '.' || $file == '..') continue;

                if (is_dir($file)){
                    if (!$this->full_rmdir($file)) return false;
                }else{
                    if (!unlink($file)) return false;
                }
            }

            closedir($dirHandle);
            chdir($old_cwd);
            if (!rmdir($dirname)) return false;

            return true;
        }else{
            return false;
        }
    }
    //--------------------------------------------------------------------------
    function sendEmail($subject,$message, $receiverEmail, $senderEmail=null)
    {
        $result = true;

        try
        {
            require_once 'files/Swift-4.0.5/lib/swift_required.php';

            
            //Create the Transport
            $transport = Swift_SmtpTransport::newInstance($this->smtp['server'], $this->smtp['port'])
                    ->setUsername($this->smtp['username'])
                    ->setPassword($this->smtp['password'])
            ;

            //Create the Mailer using your created Transport
            $mailer = Swift_Mailer::newInstance($transport);

            //Create the message
            $message = Swift_Message::newInstance()
                    ->setSubject($subject)
                    ->setTo(array($receiverEmail))
                    ->setFrom($this->smtp['username'])
                    ->setBody($message,'text/html');

            $headers = $message->getHeaders();
            
            if(!empty($senderEmail))
                $headers->addTextHeader('Reply-to', $senderEmail);

            $result = $mailer->send($message);
        }
        catch(Exception $e)
        {
            echo $e;
            $result = false;
        }
        return $result;
    }
    //--------------------------------------------------------------------------
    //ZWRACA TABLICĘ ELEMENTÓW o WYBRANYM INDEXIE ZE ZBIORU TABLIC  ASOCJACYJNYCH
    //CEL -> budowanie s�ownika opcji dla drop_down_boxa
    //$emptyFirstElement = true jeśli 1 opcja ma być pusta
    function arrayListToDictionary($source, $key,$value,$emptyFirstElement=false)
    {
            $result = null;
            if(is_array($source) && !empty($source))
            {
                    if($emptyFirstElement)
                            $result = array(''=>'');

                    foreach($source as $k=>$v)
                    {
                            if(!isset($v[$key]) || !isset($v[$value]))
                            {
                                    return false;
                            }
                            else
                            {
                                    $result[$v[$key]] = $v[$value];
                            }
                    }
            }
            return $result;
    }
}
?>
