<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

//BIBLBIOTEKA : Auth
//OPIS: uwierzytelnianie i autoryzacja

class Auth {

    protected $ci;

    //--------------------------------------------------------------------------
    function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->library('session');
        $this->ci->load->database();
        $this->ci->load->model('admin_model');
    }
    //--------------------------------------------------------------------------
    //sprawdzenie poprawności loginu i hasła
    //jesli ok to zapisanie danych do sesji
    function login($login,$password)
    {
        $user = $this->ci->admin_model->login($login,md5($password));
        if(isset($user[0]))
        {
            $user = $user[0];
            if($user['active'])
            {
                $userSessionData = array(
                    'id'        => $user['idusers'],
                    'groupId'   => $user['iduser_groups'],
                    'login'     => $login
                );
                $this->ci->session->set_userdata(array('user'=>$userSessionData));
                return true;
            }
        }
        return false;
    }
    //--------------------------------------------------------------------------
    function logout()
    {
        $this->ci->session->set_userdata(array('user'=> null));
        $this->ci->session->sess_destroy();
    }
    //--------------------------------------------------------------------------
    function isLoggedIn()
    {
        $user = $this->ci->session->userdata('user');
        return (!empty($user['id']) && !empty($user['login']) && !empty($user['groupId']));
    }
    //--------------------------------------------------------------------------
    function hasAccess($resource)
    {
        $result = false;
        if($this->isLoggedIn())
        {
            $userSessionData =  $this->ci->session->userdata('user');

            $allowed_resources = $this->ci->admin_model->get_elements_for_group($userSessionData['groupId']);
            if(isset($allowed_resources[0])){
                    foreach($allowed_resources as $allowed_resource){
                            if($allowed_resource['name'] == $resource && $allowed_resource['active'] == true){
                                    $result = true;
                                    break;
                            }
                    }
            }
        }
        return $result;
    }
    //--------------------------------------------------------------------------
    function getUserId()
    {
        return $this->getUserData('id');
    }
    //--------------------------------------------------------------------------
    function getGroupId()
    {
        return $this->getUserData('groupId');
    }
    //--------------------------------------------------------------------------
    function getLogin()
    {
        return $this->getUserData('login');
    }
    //--------------------------------------------------------------------------
    function getUserData($key=null)
    {
        $result = null;        
            if($this->isLoggedIn())
            {
                $result = $this->ci->session->userdata('user');
                if(!empty($key) && !empty($result[$key]))
                {
                    $result = $result[$key];
                }
            }
        return $result;
    }    
    //--------------------------------------------------------------------------
}
?>
