<?php

DEFINE('SLIDESHOWS_DIR','/files/slideshows');

class Slideshow extends Controller {
    
    var $localization;          //slownik z frazami obecnie uzywanego jezyka
    var $viewData;              //slownik danych przekazywanych do widokow

    function Slideshow()
    {
        parent::Controller();
        $this->config->load('localization');
        $this->localization = $this->config->item('PL');

        $this->load->model('slideshow_model');

        //custom
        $this->load->library('metatags');        
        $this->load->library('cms');
        $this->load->library('messages');
        $this->load->library('language');

        //ci
        $this->load->library('session');
        $this->load->helper('form');
        $this->load->helper('url');

        //default viewdata values
        $this->set_language(3);

        $this->viewData              = $this->cms->getMenus('slideshows');
        $this->viewData['content']   = '';
        $this->viewData['metatags']  = $this->metatags->getValue('cms',3);
    }
    //----------------------------------------------------------------------
    private function set_language($idlanguage)
    {
        $this->localization = $this->cms->get_localization($idlanguage);
    }
    //--------------------------------------------------------------------------
    //zwraca liste zdefiniowanych slideshowów
    function index()
    {
        $this->viewData['slideshow_list']   = $this->slideshow_model->getAll();

        if($this->auth->hasAccess('slideshow'))
            $this->viewData['content']  = $this->load->view('slideshow/index', $this->viewData, true);
        else
            show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));


        $this->viewData['messages']     = $this->messages->get();      

        $this->load->view('_shared/layouts/cms/header',  $this->viewData['metatags']);
        $this->load->view('_shared/layouts/cms/content', $this->viewData);
    }
    //--------------------------------------------------------------------------
    function details($id)
    {
        $id = (int)$id;
        $this->viewData['slideshow']   = $this->slideshow_model->getById($id);
        
        if($this->auth->hasAccess('slideshow'))
            $this->viewData['content']  = $this->load->view('slideshow/details', $this->viewData, true);
        else
            show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));


        $this->viewData['messages']     = $this->messages->get();
        $this->load->view('_shared/layouts/cms/header',  $this->viewData['metatags']);
        $this->load->view('_shared/layouts/cms/content', $this->viewData);
    }
    //--------------------------------------------------------------------------
    //dodawania nowego slideshowa
    function add()
    {
       if($this->auth->hasAccess('slideshow'))
       {
            $this->viewData['content']      = $this->load->view('slideshow/add', null, true);
            $this->viewData['field_errors'] = null;

            if(!empty($_POST))
            {
                //init validation
                $this->load->library('form_validation');
                $this->form_validation->set_error_delimiters('<span class="error">', '</span><br/>');
                $this->lang->switch_to('polish');

                //set rules
                $this->form_validation->set_rules('name', ucfirst($this->localization['nazwa']), 'required');


                if ($this->form_validation->run() == TRUE)
                {
                    $slideshow['name'] = set_value('name');

                    $id = $this->slideshow_model->create($slideshow);
                    if($id > 0)
                    {                        
			mkdir (".".SLIDESHOWS_DIR.'/'.$id, 0777);
                        chmod(".".SLIDESHOWS_DIR.'/'.$id, 0777);
                        
                        $this->messages->add('Operacja została wykonana pomyślnie', 'success');
                        redirect('slideshow/index','location');
                    }
                    else
                    {                        
                        $this->messages->add('Wystapił bład podczas wprowadzania danych do bazy', 'error');
                    }
                }
                else
                {                    
                    $this->messages->add($this->form_validation->error_string(), 'error');
                }
            }
       }
        else
            show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

        $this->viewData['messages']     = $this->messages->get();
        

        $this->load->view('_shared/layouts/cms/header', $this->viewData['metatags']);
        $this->load->view('_shared/layouts/cms/content',$this->viewData);
    }
    //--------------------------------------------------------------------------
    //edycja slideshowa
    function edit()
    {
        $this->viewData['slideshow_list']   = $this->slideshow_model->getAll();

        if($this->auth->hasAccess('slideshow'))
            $this->viewData['content']  = $this->load->view('slideshow/edit', $list, true);
        else
            show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

        $this->viewData['metatags']     = $this->messages->get();

        $this->load->view('_shared/layouts/cms/header', $this->viewData['metatags']);
        $this->load->view('_shared/layouts/cms/content',$this->viewData);
    }
    //--------------------------------------------------------------------------
    //usuwanie slideshowa
    function delete($id)
    {
       if(!$this->auth->hasAccess('slideshow'))
            show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

        if($this->slideshow_model->delete($id))
        {
            $this->cms->full_rmdir(".".SLIDESHOWS_DIR.'/'.$id);
            $this->messages->add('Operacja została wykonana pomyślnie', 'success');
        }
        else
            $this->messages->add('Wystapił bład podczas operacji na bazie danych', 'error');

        redirect('slideshow/index','location');
    }
    //--------------------------------------------------------------------------
    //dodawanie zdjecia do slideshowa
    function add_slide($slideshow_id)
    {
         if(!$this->auth->hasAccess('slideshow'))
            show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));


       $this->viewData['slide'] = null;

        if(!empty($_POST))
        {

            //init validation
            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<span class="error">', '</span><br/>');
            $this->lang->switch_to('polish');

            //set rules
            $this->form_validation->set_rules('name', ucfirst($this->localization['nazwa']), 'required|trim');
            $this->form_validation->set_rules('description', ucfirst($this->localization['opis']), 'trim');
            $this->form_validation->set_rules('URL', 'URL', 'trim');


            $slide['slideshow_id']  = $slideshow_id;
            $slide['name']          = empty($_POST['name'])         ? null: trim($_POST['name']);
            $slide['description']   = empty($_POST['description'])  ? null: trim($_POST['description']);
            $slide['link']          = empty($_POST['link'])         ? null: trim($_POST['link']);

            //upload
            $upload_result = null;


            if(!empty($_FILES['file']['name']))
            {
                $config['upload_path']  = '.'.SLIDESHOWS_DIR.'/'.$slideshow_id;
                $upload_result          = $this->cms->uploadFile('file',$config);
            }

            if ($this->form_validation->run() == TRUE && !isset($upload_result['error']))
            {
                if(!empty($_FILES) && !empty($upload_result['upload_data']))
                    $slide['file_path'] = SLIDESHOWS_DIR.'/'.$slideshow_id.'/'.$upload_result['upload_data']['file_name'];



                if($this->slideshow_model->createSlide($slide))
                {
                    $this->messages->add('Operacja została wykonana pomyślnie', 'success');
                    redirect('slideshow/details/'.$slideshow_id,'location');
                }
                else
                {
                    $this->messages->add('Wystapił bład podczas wprowadzania danych do bazy', 'error');
                }
            }
            else
            {
                $this->messages->add($this->form_validation->error_string(), 'error');

                if(!empty($upload_result['error']))
                    $this->messages->add(strip_tags ($upload_result['error']), 'error');
            }

            $this->viewData['slide'] = $slide;
        }
            $this->viewData['content']      = $this->load->view('slideshow/add_slide', $this->viewData, true);


        $this->viewData['messages']     = $this->messages->get();
        $this->load->view('_shared/layouts/cms/header', $this->viewData['metatags']);
        $this->load->view('_shared/layouts/cms/content',$this->viewData);
    }
    //--------------------------------------------------------------------------
    //edycja zdjęcia szablonu
    function edit_slide($slide_id)
    {
         if(!$this->auth->hasAccess('slideshow'))
            show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

        $slide        = $this->slideshow_model->getSlideById($slide_id);
        
        if(!empty($_POST))
        {
                //init validation
                $this->load->library('form_validation');
                $this->form_validation->set_error_delimiters('<span class="error">', '</span><br/>');
                $this->lang->switch_to('polish');

                //set rules
                $this->form_validation->set_rules('name', ucfirst($this->localization['nazwa']), 'required|trim');
                $this->form_validation->set_rules('description', ucfirst($this->localization['opis']), 'trim');
                $this->form_validation->set_rules('URL', 'URL', 'trim');


                
                $slide['name']          = empty($_POST['name'])         ? null: trim($_POST['name']);
                $slide['description']   = empty($_POST['description'])  ? null: trim($_POST['description']);
                $slide['link']          = empty($_POST['link'])         ? null: trim($_POST['link']);

                //upload
                $upload_result = null;


                if(!empty($_FILES['file']['name']))
                {
                    $config['upload_path']  = '.'.SLIDESHOWS_DIR.'/'.$slide['slideshow_id'];
                    $upload_result          = $this->cms->uploadFile('file',$config);
                }

                if ($this->form_validation->run() == TRUE && !isset($upload_result['error']))
                {
                    if(!empty($_FILES) && !empty($upload_result['upload_data']))
                        $slide['file_path'] = SLIDESHOWS_DIR.'/'.$slide['slideshow_id'].'/'.$upload_result['upload_data']['file_name'];


                    if($this->slideshow_model->updateSlide($slide_id,$slide))
                    {
                        $this->messages->add('Operacja została wykonana pomyślnie', 'success');
                        redirect('slideshow/details/'.$slide['slideshow_id'],'location');
                    }
                    else
                    {
                        $this->messages->add('Wystapił bład podczas wprowadzania danych do bazy', 'error');
                    }
                }
                else
                {
                    $this->messages->add($this->form_validation->error_string(), 'error');

                    if(!empty($upload_result['error']))
                        $this->messages->add(strip_tags ($upload_result['error']), 'error');
                }                
        }

        $this->viewData['slide']        = $slide;
        $this->viewData['content']      = $this->load->view('slideshow/edit_slide', $this->viewData, true);
       
        $this->viewData['metatags']     = $this->messages->get();
        $this->load->view('_shared/layouts/cms/header', $this->viewData['metatags']);
        $this->load->view('_shared/layouts/cms/content',$this->viewData);
    }
    //--------------------------------------------------------------------------
    //ajax function
    function rearrange_slides()
    {
       if(!$this->auth->hasAccess('slideshow'))
            show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));


       if(!empty($_POST['data_table']))
       {
           $slides = null;

           $rows = array_reverse($_POST['data_table']);
           foreach($rows as $k=>$v)
           {
                if($v != "")
                {
                    $slides[$k]['id']       = $v;
                    $slides[$k]['order']    = $k;
                }
           }

           if(!empty($slides))
               echo (int)($this->slideshow_model->updateMultipleSlides($slides));
       }
    }
    //--------------------------------------------------------------------------
    //usuniecie zdjecia szablonu
    function delete_slide($slide_id)
    {
       if(!$this->auth->hasAccess('slideshow'))
            show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

        $slide = $this->slideshow_model->getSlideById($slide_id);

        if($this->slideshow_model->deleteSlide($slide_id))
            $this->messages->add('Operacja została wykonana pomyślnie', 'success');
        else
            $this->messages->add('Wystapił bład podczas operacji na bazie danych', 'error');

        redirect('slideshow/details/'.$slide['slideshow_id'],'location');
    }
    //--------------------------------------------------------------------------
    function delete_slide_file($slide_id)
    {
       if(!$this->auth->hasAccess('slideshow'))
            show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

        $slide_id = (int)$slide_id;
        $slide = $this->slideshow_model->getSlideById($slide_id);
        if(!empty($slide['file_path']))
        {
            $modification['file_path'] = null;
            if($this->slideshow_model->updateSlide($slide_id,$modification))
                $this->messages->add('Operacja została wykonana pomyślnie', 'success');
            else
                $this->messages->add('Wystapił bład, operacja nie została wykonana', 'error');
        }
        else
            $this->messages->add('Wskazany slajd nie posiada pliku', 'error');

        redirect('slideshow/details/'.$slide['slideshow_id'],'location');
    }
    //--------------------------------------------------------------------------
}
?>
