<?php
class Settings extends Controller {

    var $localization;          //slownik z frazami obecnie uzywanego jezyka
    var $viewData;              //slownik danych przekazywanych do widokow

    function Settings()
    {
        parent::Controller();
        $this->config->load('localization');
        $this->localization = $this->config->item('PL');

        $this->load->model('settings_model');
        $this->load->model('admin_model');

        //custom
        $this->load->library('metatags');
        $this->load->library('cms');
        $this->load->library('messages');
        $this->load->library('language');

        //ci
        $this->load->library('session');
        $this->load->helper('form');
        $this->load->helper('url');

        //default viewdata values
        $this->viewData              = $this->cms->getMenus('settings');
        $this->viewData['content']   = '';
        $this->viewData['metatags']  = $this->metatags->getValue('cms',3);

        $this->localization = $this->cms->get_localization(3);
    }
    //--------------------------------------------------------------------------
    function index($lang_id=null)
    {
       if(!$this->auth->hasAccess('slideshow'))
            show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

        $this->localization = $this->cms->get_localization($lang_id);           //ustawienie jezyka

        $this->viewData['lang_id']              = !empty($_POST['lang_id']) ? $_POST['lang_id']:'';
        $this->viewData['dd_languages']         = $this->cms->arrayListToDictionary($this->admin_model->get_languages(),'idlanguages','shortname',true); //LANGUAGES FOR DROP DOWN
        $this->viewData['languages']            = $this->admin_model->get_languages();
                
        $this->viewData['grouped_settings']     = $this->settings_model->getAllByLang($this->viewData['lang_id']);
        $this->viewData['messages']             = $this->messages->get();
        $this->viewData['content']              = $this->load->view('settings/index', $this->viewData, true);

        $this->load->view('_shared/layouts/cms/header',  $this->viewData['metatags']);
        $this->load->view('_shared/layouts/cms/content', $this->viewData);
    }
    //--------------------------------------------------------------------------
    function add($lang_id=null)
    {
       if(!$this->auth->hasAccess('slideshow'))
            show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

        $this->localization                     = $this->cms->get_localization($lang_id);   //ustawienie jezyka

        $this->viewData['types']                = array_combine($this->settings_model->getTypes(), $this->settings_model->getTypes());
        array_unshift($this->viewData['types'], "");

        $this->viewData['categories']           = $this->cms->arrayListToDictionary($this->settings_model->getCategories(),'id','name',true);
        $this->viewData['languages']            = $this->cms->arrayListToDictionary($this->admin_model->get_languages(),'idlanguages','shortname',true);

        $this->viewData['setting']              = null;
        $this->viewData['setting_language']     = null;
        
        if(!empty($_POST))
        {
            $setting['category_id']     = isset($_POST['category_id'])          ? (string)$_POST['category_id']:null;
            $setting['name']            = isset($_POST['name'])                 ? (string)$_POST['name']:null;
            $setting['type']            = isset($_POST['type'])                 ? (string)$_POST['type']:null;
            $setting['order']           = isset($_POST['order'])                ? (int)$_POST['order']:null;


            $setting['name']            = url_title($setting['name'], 'underscore', TRUE);

            $setting_language['lang_id']         = isset($_POST['lang_id'])     ? (int)$_POST['lang_id']:null;
            if(empty($setting_language['lang_id']))
                $setting_language['lang_id'] = null;

            $setting_language['value']           = isset($_POST['value'])       ? (string)$_POST['value']:null;
            $setting_language['description']     = isset($_POST['description']) ? (string)$_POST['value']:null;

            if($this->settings_model->create($setting, $setting_language))
            {
                $this->messages->add('Operacja została wykonana pomyślnie', 'success');
                redirect('settings/index/'.$setting_language['lang_id'],'location');
            }
            else
            {
                $this->messages->add('Wystapił bład podczas wprowadzania danych do bazy', 'error');
                $this->viewData['setting']          = $setting;
                $this->viewData['setting_language'] = $setting_language;
            }
        }

        $this->viewData['messages']             = $this->messages->get();
        $this->viewData['content']              = $this->load->view('settings/add', $this->viewData, true);
        
        $this->load->view('_shared/layouts/cms/header',  $this->viewData['metatags']);
        $this->load->view('_shared/layouts/cms/content', $this->viewData);        
    }
    //--------------------------------------------------------------------------
    function add_lang($setting_id, $setting_language_lang_id, $lang_id = 3)
    {
       if(!$this->auth->hasAccess('slideshow'))
            show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

        $this->localization                     = $this->cms->get_localization($lang_id);   //ustawienie jezyka

        $this->viewData['types']                = array_combine($this->settings_model->getTypes(), $this->settings_model->getTypes());
        array_unshift($this->viewData['types'], "");

        $this->viewData['categories']           = $this->cms->arrayListToDictionary($this->settings_model->getCategories(),'id','name',true);
        $this->viewData['languages']            = $this->cms->arrayListToDictionary($this->admin_model->get_languages(),'idlanguages','shortname',true);

        $this->viewData['setting']              = $this->settings_model->getById($setting_id);

        
        
        $this->viewData['setting_language']     = null;
        $this->viewData['setting_language']['lang_id'] = $setting_language_lang_id;

        if(!empty($_POST))
        {
            $setting_language['setting_id']         = $setting_id;
            $setting_language['lang_id']            = $setting_language_lang_id;
            

            $setting_language['value']           = isset($_POST['value'])       ? (string)$_POST['value']:null;
            $setting_language['description']     = isset($_POST['description']) ? (string)$_POST['value']:null;

            if($this->settings_model->createLanguage($setting_language))
            {
                $this->messages->add('Operacja została wykonana pomyślnie', 'success');
                redirect('settings/index','location');
            }
            else
            {
                $this->messages->add('Wystapił bład podczas wprowadzania danych do bazy', 'error');
                $this->viewData['setting_language'] = $setting_language;
            }
        }

        $this->viewData['messages']             = $this->messages->get();
        $this->viewData['content']              = $this->load->view('settings/add_lang', $this->viewData, true);

        $this->load->view('_shared/layouts/cms/header',  $this->viewData['metatags']);
        $this->load->view('_shared/layouts/cms/content', $this->viewData);
    }
    //--------------------------------------------------------------------------
    function edit($category_id,$lang_id=null)
    {
       if(!$this->auth->hasAccess('slideshow'))
            show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

        $this->localization                     = $this->cms->get_localization($lang_id);   //ustawienie jezyka

        $this->viewData['lang_id']      = $lang_id;
        $this->viewData['category']     = $this->settings_model->getCategory($category_id);
        $this->viewData['settings']     = $this->settings_model->getByCategoryId($category_id,$lang_id);
        $this->viewData['messages']     = $this->messages->get();

        if(!empty($_POST))
        {
            $fields = $_POST['fields'];
            if(!empty($fields))
            {
                if($this->settings_model->update($fields,$lang_id))
                {
                    $this->messages->add('Operacja została wykonana pomyślnie', 'success');
                    redirect('settings/index','location');
                }
                else
                {
                    foreach($fields as $k=>$f)
                    {
                        $this->viewData['settings'][$k]   = trim($f);
                    }
                    $this->messages->add('Wystapił bład', 'error');
                }

            }
        }
        $this->viewData['content']      = $this->load->view('settings/edit', $this->viewData, true);

        $this->load->view('_shared/layouts/cms/header',  $this->viewData['metatags']);
        $this->load->view('_shared/layouts/cms/content', $this->viewData);
    }
    //--------------------------------------------------------------------------
    function delete($id, $lang_id=null)
    {
        if($this->settings_model->delete($id))
            $this->messages->add('Operacja została wykonana pomyślnie', 'success');
        else
            $this->messages->add('Wystapił błąd podczas operacji na bazie danych', 'error');

        redirect('settings/index','location');
    }
    //--------------------------------------------------------------------------
}
?>
