<?php
class Frontside extends Controller {

	var $cache_duration         = 0;
        var $main_menu_id           = 1;
        var $default_language_id    = 3;
        var $settings;
	var $localization;

	function Frontside(){
            parent::Controller();
            $this->load->model('frontside_model','',TRUE);
            $this->load->model('admin_model','',TRUE);
            $this->load->model('list_model','',TRUE);
            $this->load->model('menu_model','',TRUE);
            $this->load->model('slideshow_model','',TRUE);
            $this->load->model('settings_model','',TRUE);


            $this->config->load('localization');
            //rozmiary miniaturek


            $this->load->library('session');
            $this->load->library('metatags');
            $this->load->library('cms');

            $this->load->helper('form');
            $this->load->helper('url');
            $this->load->helper('text');

            //init
            $this->set_language($this->default_language_id);
	}
	//----------------------------------------------------------------------
        private function set_language($idlanguage)
        {
            $this->localization = $this->cms->get_localization($idlanguage);
            $this->settings     = $this->settings_model->getAllAsDictionary($idlanguage);
        }
	//----------------------------------------------------------------------
	function index($idlang = null)
        {
            $idlang = is_null($idlang) ? $this->default_language_id:$idlang;

            $this->set_language($idlang);
            $this->output->cache($this->cache_duration);

            $article                    = $this->frontside_model->get_first_article($idlang);

            


            $content_data['article']    = $article;

            if(!empty($article->idlists))
            {
                $listId                 = $article->idlists;
                $data['list']   = $this->list_model->getElementsByParentId($listId);
            }
            if(!empty($article->idslideshow))
            {
                $slideshow                      = $this->slideshow_model->getById($article->idslideshow);
                $data['slideshow']      = $this->load->view('front/elements/slideshow',array('slideshow'=>$slideshow),true);
            }

            $langs                  = $this->frontside_model->get_active_languages();
            $data['langs_menu']     = $this->load->view('front/elements/menu_lang',array('langs'=>$langs,'active_lang'=>$idlang),true);

            $data['home_page']      = true;
            $data['content']        = $this->load->view('front/index', $content_data, true);

            
            
            //main menu
            $menu_items             = $this->menu_model->getById($this->main_menu_id, $idlang,$this->localization,isset($article->idarticles) ? $article->idarticles : null,'artykul');
            $data['main_menu']      = $this->load->view('front/elements/main_menu', array('menu_items'=>$menu_items), true);

            $data['metatags']       = $this->metatags->getValue('frontside',$idlang,(array)$article);

            $this->load->view('front/layout/default/header', $data);
            $this->load->view('front/layout/default/content', $data);
            $this->load->view('front/layout/default/footer');
	}
    //-------------------------------------------------------------------------------------------------------------------
    //nie przystosowany do języków
    function articles($idlang = null)
    {
        $idlang = is_null($idlang) ? $this->default_language_id:$idlang;

        $this->set_language($idlang);
        $this->output->cache($this->cache_duration);

        $content_data['articles']   = $this->frontside_model->get_articles($idlang);
        $data['content']            = $this->load->view('front/articles', $content_data, true);

        //main menu
        $menu_items             = $this->menu_model->getById($this->main_menu_id, $idlang,$this->localization);
        $data['main_menu']      = $this->load->view('front/elements/main_menu', array('menu_items'=>$menu_items), true);

        $data['metatags']       = $this->metatags->getValue('artykuly',$idlang);

        $this->load->view('front/layout/default/header', $data);
        $this->load->view('front/layout/default/content', $data);
        $this->load->view('front/layout/default/footer');
    }
    //--------------------------------------------------------------------------
    function article($id, $idlang = null)
    {
            $idlang = is_null($idlang) ? $this->default_language_id:$idlang;

            $this->set_language($idlang);
            $this->output->cache($this->cache_duration);

            $home_article = $this->frontside_model->get_first_article($idlang);


            if(!empty($home_article->idarticles) && $home_article->idarticles == $id)
            {
                return $this->index($idlang);
            }

            //pobierz pod artykuly - jeśli są przekierwuj rządanie na jego widok
            /*
            $subarticles = $this->frontside_model->get_subarticles($id, $idlang);
            if(!empty($subarticles) && is_array($subarticles))
            {
                switch($idlang)
                {
                    case 4: redirect(base_url().'en/article/'.$subarticles[0]['friendlyurl'].'-'.$subarticles[0]['idarticles'].'.html');
                    default: redirect(base_url().'pl/artykul/'.$subarticles[0]['friendlyurl'].'-'.$subarticles[0]['idarticles'].'.html');
                }
            }*/




        //galeria
        $gallery        = $this->frontside_model->get_first_gallery($idlang);
        if(!empty($gallery))
            $gallery['images'] = $this->frontside_model->get_gallery_images($gallery['idgalleries'],$idlang);

        //praca nad artykułem

        $article        = $this->frontside_model->get_article($id, $idlang);
        $listId         = !empty($article[0]['idlists']) ? $article[0]['idlists'] : null;
        $lista          = null;

        if(!empty($listId))
        {
            $lista   = $this->list_model->getElementsByParentId($listId);
        }


            //main menu
            $menu_items             = $this->menu_model->getById($this->main_menu_id, $idlang,$this->localization,$id,'artykul');
            $data['main_menu']      = $this->load->view('front/elements/main_menu', array('menu_items'=>$menu_items), true);


        if(isset($article[0]))
        {

            $article = $article[0];

            if($article['idgalleries']!=''){
                $article['galleries'] = $this->frontside_model->get_images_by_idgallery($article['idgalleries']);
            }

            if(!empty($article['idslideshow']))
            {
                $slideshow             = $this->slideshow_model->getById($article['idslideshow']);
                $data['slideshow']     = $this->load->view('front/elements/slideshow',array('slideshow'=>$slideshow),true);
            }

            $list['article'] = $article;
            $parent = $this->frontside_model->get_article($article['idparent'], $idlang);

            if(isset($parent[0])){
                    $article['parent'] = $parent[0];
                    $list['parent'] = $parent[0];
                    if($article['parent']['idparent']==''){
                            $article['subarticles'] = $this->frontside_model->get_subarticles($article['parent']['idarticles'], $idlang);
                            $list['subarticles'] = $article['subarticles'];
                            $article['subarticles_content'] = $this->frontside_model->get_subarticles($id, $idlang);
                    }else{
                            $article['subarticles'] = $this->frontside_model->get_subarticles($article['parent']['idparent'], $idlang);
                            $article['subarticles_content'] = $this->frontside_model->get_subarticles($id, $idlang);
                    }
            }else{
                    $article['subarticles']         = $this->frontside_model->get_subarticles($id, $idlang);
                    $article['subarticles_content'] = $article['subarticles'];

            }


            if(!empty($article['image1']))
                $data['header_image']      = $this->load->view('front/elements/header_image',array('image'=> $article['image1']),true);


            $top_article                        = $this->frontside_model->get_top_parent_for_child_article($id, $idlang);
            $articles_tree                      = $this->frontside_model->get_articles_tree($idlang, !empty($top_article['idarticles']) ? $top_article['idarticles']:null);
            $content_data['articles_menu']      = $this->load->view('front/elements/articles_menu',array('articles'=> $articles_tree,'article_id'=>$id),true);


            $langs                  = $this->frontside_model->get_active_languages();
            $data['langs_menu']     = $this->load->view('front/elements/menu_lang',array('langs'=>$langs,'active_lang'=>$idlang),true);

            if($id == 4)
                $data['realizacje_page']      = true;

            $content_data['article']        = $article;
            $data['content']                = $this->load->view('front/article', $content_data, true);
            $metatags = $this->metatags->getValue('frontside',$idlang,(array)$article);
        }
        else
        {
            $metatags           = $this->metatags->getValue('frontside',$idlang);
            //$data['content']    = $this->load->view('front/article', array('message'=> '<p class="info_box">Nie ma takiej strony</a>'), true);
            return $this->error(404, $idlang);
        }

        $data['metatags']           = $metatags;


        $this->load->view('front/layout/default/header', $data);
        $this->load->view('front/layout/default/content', $data);
        $this->load->view('front/layout/default/footer',$data);
    }
    //--------------------------------------------------------------------------
    function newses($idlang = null)
    {
            $idlang = is_null($idlang) ? $this->default_language_id:$idlang;

            $this->set_language($idlang);
            $this->output->cache($this->cache_duration);


            $content_data['newses'] = $this->frontside_model->get_newses($idlang);
            $data['content'] = $this->load->view('front/newses', $content_data, true);


            //main menu
            $menu_items             = $this->menu_model->getById($this->main_menu_id, $idlang,$this->localization);
            $data['main_menu']      = $this->load->view('front/elements/main_menu', array('menu_items'=>$menu_items), true);

            $data['metatags'] = $this->metatags->getValue('newsy',$idlang);

            //langs menu
            $langs                  = $this->frontside_model->get_active_languages();
            $data['langs_menu']     = $this->load->view('front/elements/menu_lang',array('langs'=>$langs,'active_lang'=>$idlang),true);

            $this->load->view('front/layout/default/header', $data);
            $this->load->view('front/layout/default/content', $data);
            $this->load->view('front/layout/default/footer',$data);
    }
    //--------------------------------------------------------------------------
    function news($id = null, $idlang = null)
    {
        $idlang = is_null($idlang) ? $this->default_language_id:$idlang;

        $this->set_language($idlang);
        $this->output->cache($this->cache_duration);

        $content_data['newses']     = $this->frontside_model->get_newses($idlang);
        $content_data['news']       = $this->frontside_model->get_news($id,$idlang);



        //newses menu
        $content_data['newses_menu']        = $this->load->view('front/elements/newses_menu',array('newses'=> $content_data['newses'],'news_id'=>$id),true);
        $data['content']                    = $this->load->view('front/news', $content_data, true);

        //main menu
        $menu_items             = $this->menu_model->getById($this->main_menu_id, $idlang,$this->localization);
        $data['main_menu']      = $this->load->view('front/elements/main_menu', array('menu_items'=>$menu_items), true);

        $data['metatags'] = $this->metatags->getValue('newsy',$idlang,(array)$content_data['news']);


        //langs menu
        $langs                  = $this->frontside_model->get_active_languages();
        $data['langs_menu']     = $this->load->view('front/elements/menu_lang',array('langs'=>$langs,'active_lang'=>$idlang),true);

        $this->load->view('front/layout/default/header', $data);
        $this->load->view('front/layout/default/content', $data);
        $this->load->view('front/layout/default/footer',$data);
    }
    //--------------------------------------------------------------------------
    function gallery($id = null, $idlang = null)
        {
            $idlang = is_null($idlang) ? $this->default_language_id:$idlang;
            $this->set_language($idlang);
            $this->output->cache($this->cache_duration);


        $article = $this->frontside_model->get_gallery_by_id($id,$idlang);
        if(isset($article[0])){
                //"artykul dostepny takze w jezykach"
                $other_languages = $this->frontside_model->get_gallery($id);
                //print_r($other_languages);
                $other_versions = '';
                if(isset($other_languages[1])){
                        $other_versions .= ucfirst($this->localization['wersje_jezykowe']);
                        $i=0;
                        foreach($other_languages as $other_lang_version){
                                if($this->localization['lang']['skrot']!=$other_lang_version['shortname']){
                                        $current_lang = $this->config->item($other_lang_version['shortname']);
                                        if($i==0){
                                                $i++;
                                        }else{
                                                $other_versions .=  ' | ';
                                        }
                                        $link = '/'.$other_lang_version['friendlyurl'].'-6-'.$this->localization['meta_data']['idlanguages'].'-'.$other_lang_version['idgalleries'].'.html';

                                        $other_versions .=  '<a href="'.$link.'">'.$other_lang_version['shortname'].'</a>';
                                }
                        }
                }
                $data['other_versions'] = $other_versions;
                //praca nad artykułem
                $article            = $article[0];

                $gallery_categories                 = $this->admin_model->get_gallery_categories_languages($idlang);

                $gallery                            = $this->admin_model->get_gallery_by_id($id,$idlang);
                $galleries_in_current_category      = $this->frontside_model->get_galleries_by_category_id($gallery[0]['idcategory'],$idlang);


                if($gallery[0]['idcategory'] == 1)
                    $article['is_web'] = true;
                else
                    $article['is_web'] = false;





                $article['gallery_categories_menu']     = $this->load->view('front/elements/gallery_categories_menu', array('categories'=>$gallery_categories,'active_category_id'=>$gallery[0]['idcategory']), true);
                $article['galleries_menu']              = $this->load->view('front/elements/galleries_menu', array('galleries'=>$galleries_in_current_category,'active_gallery_id'=>$id), true);

                $article['gallery']                     = $gallery[0];
                $article['images']                      = $this->frontside_model->get_gallery_images($id,$idlang);
                $article['active_lang']                 = $idlang;

                $data['content']                        = $this->load->view('front/gallery', $article, true);
                 $data['metatags']                                = $this->metatags->getValue('frontside',$idlang,(array)$article);

        }else{
                $data['metatags']   = $this->metatags->getValue('frontside',$idlang);
                $data['content']    = '<div class="main_block">'.$this->localization['wybrana_strona_nie_istnieje'].'</div>';
        }

        //newsy
        $news['newses'] = $this->frontside_model->get_newses($idlang,2);
        $data['news']   = $this->load->view('front/elements/newses_box',$news,true);



        $langs                  = $this->frontside_model->get_active_languages();
        $data['langs_menu']     = $this->load->view('front/elements/menu_lang',array('langs'=>$langs,'active_lang'=>$idlang),true);

        //main menu
        $menu_items             = $this->menu_model->getById($this->main_menu_id, $idlang,$this->localization,$id,'galeria');
        $data['main_menu']      = $this->load->view('front/elements/main_menu', array('menu_items'=>$menu_items), true);

        $this->load->view('front/layout/default/header', $data);
        $this->load->view('front/layout/default/content', $data);
        $this->load->view('front/layout/default/footer',$data);
    }
    //--------------------------------------------------------------------------
    function galleries($id = null, $idlang = null)
    {
            $idlang = is_null($idlang) ? $this->default_language_id:$idlang;
            $this->set_language($idlang);
            $this->output->cache($this->cache_duration);

            $articles = $this->frontside_model->get_galleries($idlang);

            //przekieruj na 1 galerie
            if(isset($articles[0]))
            {
                $redirect_link = '/'.url_title($articles[0]['name'], 'dash', TRUE).'-6-'.$this->localization['meta_data']['idlanguages'].'-'.$articles[0]['idgalleries'].'.html';
                redirect($redirect_link,'location');
            }

            if(isset($articles[0])){
                    foreach($articles as $key => $art){
                            $bufor = $this->frontside_model->get_gallery_images($art['idgalleries'],$idlang);
                            if(isset($bufor[0])){
                                    $articles[$key]['photo'] = $bufor[0];
                            }

                    }
                    //praca nad artykułem
                    $article['articles']    = $articles;
                    $article['site']        = $this->localization;
                    $article['subarticles'] = array();

                    $data['content'] = $this->load->view('front/galleries', $article, true);
                    $data['metatags']        = $this->metatags->getValue('galerie',$idlang,(array)$article);
            }else{
                    $data['metatags']       = $this->metatags->getValue('galerie',$idlang);
                    $data['content']        = 'Nie ma takiej galerii.';
                    $article['subarticles'] = array();
            }


            //langs menu
            $langs                  = $this->frontside_model->get_active_languages();
            $data['langs_menu']     = $this->load->view('front/elements/menu_lang',array('langs'=>$langs,'active_lang'=>$idlang),true);

            $this->load->view('front/layout/default/header', $data);
            $this->load->view('front/layout/default/content', $data);
            $this->load->view('front/layout/default/footer', $data);
    }
    //--------------------------------------------------------------------------
    //ksiega gosci - guest book
    function guest_book($id=99,$idlang = null)
    {
            $idlang = is_null($idlang) ? $this->default_language_id : $idlang;

            $this->set_language($idlang);
            $this->output->cache($this->cache_duration);


            if(!empty($_POST['title']) and !empty($_POST['text']))
            {
                    $this->frontside_model->add_guest(trim(strip_tags($_POST['title'])),trim(strip_tags($_POST['text'])));
            }

           //newsy
            $news['newses'] = $this->frontside_model->get_newses($idlang,2);
            //$data['news'] = $this->load->view('front/boxes/newses_box',$news,true);

            //menu glowne
            $list['menu_items'] = $this->frontside_model->get_menu_by_id($this->menu_poziom, $idlang);
            $data['menu_poziom'] = $this->load->view('front/menu_poziom_trollandia', $list, true);

            $guests['guests']= $this->frontside_model->get_all_guests();

            $data['content'] = $this->load->view('front/guest_book', $guests, true);

            $data['metatags']   = $this->metatags->getValue('frontside',$idlang);

            //langs menu
            $langs                  = $this->frontside_model->get_active_languages();
            $data['langs_menu']     = $this->load->view('front/elements/menu_lang',array('langs'=>$langs,'active_lang'=>$idlang),true);

            $this->load->view('front/layout/default/header'  , $data);
            $this->load->view('front/layout/default/content' ,$data);
            $this->load->view('front/layout/default/footer',$data);
    }
    //--------------------------------------------------------------------------
    function rss($idlang=null)
    {
        $idlang = is_null($idlang) ? $this->default_language_id:$idlang;
        $this->set_language($idlang);
        $this->output->cache($this->cache_duration);

        $data['metatags']   = $this->metatags->getValue('frontside',$idlang);
        $data['newses']     = $this->frontside_model->get_newses($idlang);

        $this->load->view('front/rss',$data);
    }
    //--------------------------------------------------------------------------
    function error($error_code,$idlang=null)
    {
            $idlang = is_null($idlang) ? $this->default_language_id : $idlang;
            $this->set_language($idlang);
            $this->output->cache($this->cache_duration);


            if(isset($this->localization['komunikat_bledu_'.$error_code]))
                $content_data['error']      = $this->localization['komunikat_bledu_'.$error_code];
            else
                $content_data['error']      = $this->localization['komunikat_bledu_nieokreslonego'];

            $data['content']            = $this->load->view('front/error', $content_data, true);



            //main menu
            $menu_items             = $this->menu_model->getById($this->main_menu_id, $idlang,$this->localization);
            $data['main_menu']      = $this->load->view('front/elements/main_menu', array('menu_items'=>$menu_items), true);


            $data['metatags']       = $this->metatags->getValue('frontside',$idlang);

            //langs menu
            $langs                  = $this->frontside_model->get_active_languages();
            $data['langs_menu']     = $this->load->view('front/elements/menu_lang',array('langs'=>$langs,'active_lang'=>$idlang),true);

            $this->load->view('front/layout/default/header', $data);
            $this->load->view('front/layout/default/content', $data);
            $this->load->view('front/layout/default/footer',$data);
    }
    //--------------------------------------------------------------------------
    //POBIERA Z POSTA DANE Z FORMULARZA => WYSYŁA MAILA => ZWRACA KOMUNIKAT
    function send_email()
    {
        if(!empty($_POST))
        {
            $person_name    = isset($_POST['person_name'])    ? $_POST['person_name']   :'';
            $company_name   = isset($_POST['company_name'])   ? $_POST['company_name']  :'';
            $email          = isset($_POST['email'])          ? $_POST['email']         :'';
            $telephone      = isset($_POST['telephone'])      ? $_POST['telephone']     :'';
            $subject        = isset($_POST['subject'])        ? $_POST['subject']       :'';
            $message        = isset($_POST['message'])        ? $_POST['message']       :'';

            $final_message        = '';

            if(!empty($person_name))
                $final_message        .= 'OSOBA: '.$person_name.'<br />';

            if(!empty($company_name))
                $final_message        .= 'FIRMA: '.$company_name.'<br />';

            if(!empty($email))
                $final_message        .= 'EMAIL: '.$email.'<br />';

            $final_message        .= '<br />WIADOMOŚĆ:<br />'.$message;


            if($this->cms->sendEmail($subject, $final_message, $this->settings['rozne']['contact_email'],$email))
               echo $this->localization['wiadomosc_zostala_wyslana'];
            else
               echo $this->localization['wystapil_blad'];
        }
    }
    //--------------------------------------------------------------------------
}
?>