<?php
class Admin extends Controller {
    
        var $localization;          //slownik z frazami obecnie uzywanego jezyka
        var $viewData;              //slownik danych przekazywanych do widokow

    //
	//zmienne przechowujące wymiary miniaturek newsa i galerii
	var $news = array();
	var $product = array();
	var $gal_img = array();
	
        //zapoznaj sie z zaladowanymi configami, bibliotekami, helperami itd
	function Admin(){
		parent::Controller();	
		$this->load->model('admin_model','',TRUE);
                $this->load->model('frontside_model','',TRUE);
                
                $this->load->model('list_model');
                $this->load->model('slideshow_model');
                $this->load->library('messages');
                $this->load->library('metatags');
                $this->load->library('auth');
                $this->load->library('cms');

		$this->load->library('session');
                $this->load->library('language');
		$this->load->helper('form');		
		$this->load->helper('url');
		
		$this->config->load('localization');
		//rozmiary miniaturek
		$this->config->load('file');
                
		$this->localization = $this->config->item('PL');
		$this->news         = $this->config->item('news');
		$this->product      = $this->config->item('product');
		$this->gal_img      = $this->config->item('gal_img');

                
                $this->set_language(3);
	}
	
	function index($idlang = 3){
		$data = $this->cms->getMenus();

                if(!$this->auth->isLoggedIn())
                    $data['content']  = $this->load->view('_shared/layouts/cms/login','',true);

                $data['messages']   = $this->messages->get();
		$metatags           = $this->metatags->getValue('cms',$idlang);
		$this->load->view('_shared/layouts/cms/header', $metatags);
		$this->load->view('_shared/layouts/cms/admin',$data);
	}
	
//inne funkcje		
	function login()
        {
            if(!empty($_POST))
            {
                if(!$this->auth->login($this->input->post('login'), $this->input->post('password')))
                {
                    $this->messages->add('Nieprawidłowy użytkownik lub hasło.', 'error');
                }

            }
            redirect('/admin/index', 'location');
	}
	
	function logout(){
            $this->auth->logout();
            redirect('/admin', 'location');
	}
	
	//funkcja dba o aktualizowanie języka
	private function set_language($idlang)
        {
            $this->localization = $this->cms->get_localization($idlang);
	}

        //users
	function users($idlang = 3){	
		$data = $this->cms->getMenus('users');
		$list['users'] = $this->admin_model->get_users();


		$content = $this->load->view('admin/users', $list, true);

                if($this->auth->hasAccess('users'))
                        $data['content'] = $content;
                else
                        show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));
		
		$metatags = $this->metatags->getValue('cms',$idlang);
		$this->load->view('_shared/layouts/cms/header', $metatags);
		$this->load->view('_shared/layouts/cms/admin',$data);
	}
	
	function delete_user($id){
		$group = $this->session->userdata('group');

                if($this->auth->hasAccess('users'))
                        $this->admin_model->delete_user($id);
                else
                {
                        show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));
                        exit();
                }
		redirect('/admin/users', 'location');		
	}
	
	function add_user($idlang = 3){
		$allow =  $this->auth->hasAccess('users');
		$data = $this->cms->getMenus('users');
		
		if($allow){			
			if(isset($_POST['login']) && $_POST['login'] != '' && isset($_POST['password']) && $_POST['password'] != ''){
					
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
				
				$data=array('idusers' => '',
							'iduser_groups' => $_POST['iduser_groups'],
							'fname' => $_POST['fname'],
							'lname' => $_POST['lname'],
							'login' => $_POST['login'],
							'password' => md5($_POST['password']),
							'active' => $active
				);
				$this->admin_model->add_user($data);
				redirect('/admin/users', 'location');	
			}else{
				//przygotowanie listy grup do boxa
				$groups = $this->admin_model->get_groups();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($groups as $group){
					$bufor1[$i]=$group['iduser_groups'];
					$bufor2[$i]=$group['name'];
					$i++;
				}
				$data['groups']=array_combine($bufor1,$bufor2);				
				
				$data['content'] = $this->load->view('admin/add_user', $data, true);
				
				$group = $this->session->userdata('group');
				
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}

	function edit_user($id=null, $idlang = 3){
		$allow = $this->auth->hasAccess('users');
		if($allow){			
			if(isset($_POST['login']) && $_POST['login'] != ''){
					
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
				
				$data=array('iduser_groups' => $_POST['iduser_groups'],
							'fname' => $_POST['fname'],
							'lname' => $_POST['lname'],
							'login' => $_POST['login'],
							'active' => $active
				);
				if(isset($_POST['password']) && $_POST['password']!=''){
					$data['password'] = md5($_POST['password']);
				}
				$this->admin_model->update_user($id,$data);
				unset($_POST);
				redirect('/admin/users', 'location');	
			}else{
				$data = $this->cms->getMenus('users');
				$user = $this->admin_model->get_user_by_id($id);
				if(isset($user[0])){
					$user=$user[0];
					$data['idusers'] = $id;
					$data['iduser_groups'] = $user['iduser_groups'];
					$data['fname'] = $user['fname'];
					$data['lname'] = $user['lname'];
					$data['login'] = $user['login'];
					$data['active'] = $user['active'];
				//przygotowanie listy grup do boxa
					$bufor1=array($user['iduser_groups']);
					$bufor2=array('-----');
					$i = 1;
				}else{
					$bufor1=array();
					$bufor2=array();
					$i = 0;
				}
				$groups = $this->admin_model->get_groups();
				foreach($groups as $group){
					$bufor1[$i]=$group['iduser_groups'];
					$bufor2[$i]=$group['name'];
					$i++;
				}
				$data['groups']=array_combine($bufor1,$bufor2);
								
				$data['content'] = $this->load->view('admin/edit_user', $data, true);
				
				$metatags = array();
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}

        //galleries
        //----------------------------------------------------------------------
        function gallery_categories($idlang = 3)
        {
            if(!$this->auth->hasAccess('galleries'))
                    show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

                $content_data['langs']                       = $this->admin_model->get_languages();
		$content_data['gallery_categories']          = $this->admin_model->get_gallery_categories();

		$data            = $this->cms->getMenus('galleries');

		$data['content'] = $this->load->view('admin/gallery_categories', $content_data, true);

		$metatags               = $this->metatags->getValue('cms',$idlang);
                $data['messages']       = $this->messages->get();
		$this->load->view('_shared/layouts/cms/header', $metatags);
		$this->load->view('_shared/layouts/cms/admin',$data);
        }
        //----------------------------------------------------------------------
        function add_gallery_category($idlang = 3)
        {
            if(!$this->auth->hasAccess('galleries'))
                    show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

            
                $content_data = null;
                $languages = $this->admin_model->get_languages();
                $content_data['languages']  = $this->cms->arrayListToDictionary($languages,'idlanguages','shortname',true);

                if(!empty($_POST))
                {
                    //init validation
                    $this->load->library('form_validation');
                    $this->form_validation->set_error_delimiters('<span class="error">', '</span><br/>');
                    $this->lang->switch_to('polish');

                    //set rules
                    $this->form_validation->set_rules('name',       ucfirst($this->localization['nazwa']), 'required');
                    $this->form_validation->set_rules('lang_id',    ucfirst($this->localization['jezyk']), 'required');
                    $this->form_validation->set_rules('title',      ucfirst($this->localization['tytul']), '');
                    $this->form_validation->set_rules('keywords',   ucfirst($this->localization['slowa_kluczowe']), '');
                    $this->form_validation->set_rules('shortdesc',  ucfirst($this->localization['opis']), '');

                    $this->form_validation->set_rules('active',  ucfirst($this->localization['aktywnosc']), '');

                     $content_data['gallery_category_languages']['name']                  = isset($_POST['name'])       ? $_POST['name']        :null;
                     $content_data['gallery_category_languages']['lang_id']               = isset($_POST['lang_id'])    ? $_POST['lang_id']     :null;
                     $content_data['gallery_category_languages']['title']                 = isset($_POST['title'])      ? $_POST['title']       :null;
                     $content_data['gallery_category_languages']['keywords']              = isset($_POST['keywords'])   ? $_POST['keywords']    :null;
                     $content_data['gallery_category_languages']['shortdesc']             = isset($_POST['shortdesc'])  ? $_POST['shortdesc']   :null;

                     $content_data['gallery_category']['active']                          = isset($_POST['active']) ? 1:0;

                      if ($this->form_validation->run() == TRUE)
                      {
                         if($this->admin_model->add_gallery_category($content_data['gallery_category'], $content_data['gallery_category_languages']))
                         {
                            $this->messages->add('Operacja została wykonana pomyślnie', 'success');
                            redirect('admin/gallery_categories','location');
                         }
                         else
                         {
                            $this->messages->add('Wystapił bład podczas wprowadzania danych do bazy', 'error');
                         }
                      }
                      else
                          $this->messages->add($this->form_validation->error_string(), 'error');
                }
		$data            = $this->cms->getMenus('galleries');
		$data['content'] = $this->load->view('admin/add_gallery_category', $content_data, true);

            $metatags               = $this->metatags->getValue('cms',$idlang);
            $data['messages']       = $this->messages->get();
            $this->load->view('_shared/layouts/cms/header', $metatags);
            $this->load->view('_shared/layouts/cms/admin',$data);
        }
        //----------------------------------------------------------------------
        function add_gallery_category_language($category_id,$lang_id,$idlang = 3)
        {
            if(!$this->auth->hasAccess('galleries'))
                    show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

            $data                                       = $this->cms->getMenus('galleries');
            $content_data['gallery_category']           = $this->admin_model->get_gallery_category($category_id);

            $lang = $this->admin_model->get_language_by_id($lang_id);
            $content_data['lang']                       = $lang[0];

            $content_data['gallery_category_language']  = null;
            if(!empty($_POST))
            {
                    //init validation
                    $this->load->library('form_validation');
                    $this->form_validation->set_error_delimiters('<span class="error">', '</span><br/>');
                    $this->lang->switch_to('polish');

                    //set rules
                    $this->form_validation->set_rules('name',       ucfirst($this->localization['nazwa']), 'required');
                    $this->form_validation->set_rules('lang_id',    ucfirst($this->localization['jezyk']), 'required');
                    $this->form_validation->set_rules('title',      ucfirst($this->localization['tytul']), '');
                    $this->form_validation->set_rules('keywords',   ucfirst($this->localization['slowa_kluczowe']), '');
                    $this->form_validation->set_rules('shortdesc',  ucfirst($this->localization['opis']), '');

                     $content_data['gallery_category_language']['category_id']           = $category_id;
                     $content_data['gallery_category_language']['name']                  = isset($_POST['name'])       ? $_POST['name']        :null;
                     $content_data['gallery_category_language']['lang_id']               = isset($_POST['lang_id'])    ? $_POST['lang_id']     :null;
                     $content_data['gallery_category_language']['title']                 = isset($_POST['title'])      ? $_POST['title']       :null;
                     $content_data['gallery_category_language']['keywords']              = isset($_POST['keywords'])   ? $_POST['keywords']    :null;
                     $content_data['gallery_category_language']['shortdesc']             = isset($_POST['shortdesc'])  ? $_POST['shortdesc']   :null;


                      if ($this->form_validation->run() == TRUE)
                      {
                         if($this->admin_model->add_gallery_category_language($content_data['gallery_category_language']))
                         {
                            $this->messages->add('Operacja została wykonana pomyślnie', 'success');
                            redirect('admin/gallery_categories','location');
                         }
                         else
                         {
                            $this->messages->add('Wystapił bład podczas wprowadzania danych do bazy', 'error');
                         }
                      }
                      else
                          $this->messages->add($this->form_validation->error_string(), 'error');
                    
            }
            
            $data['content'] = $this->load->view('admin/add_gallery_category_language', $content_data, true);

            $metatags               = $this->metatags->getValue('cms',$idlang);
            $data['messages']       = $this->messages->get();
            $this->load->view('_shared/layouts/cms/header', $metatags);
            $this->load->view('_shared/layouts/cms/admin',$data);
        }
        //----------------------------------------------------------------------
        function edit_gallery_category_language($category_id,$lang_id,$idlang = 3)
        {
            if(!$this->auth->hasAccess('galleries'))
                    show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

            $data                   = $this->cms->getMenus('galleries');
            $lang = $this->admin_model->get_language_by_id($lang_id);



            $content_data['lang']                       = $lang[0];            
            $content_data['gallery_category_language']  = $this->admin_model->get_gallery_categories_language($category_id,$lang_id);

            if(!empty($_POST))
            {
                    //init validation
                    $this->load->library('form_validation');
                    $this->form_validation->set_error_delimiters('<span class="error">', '</span><br/>');
                    $this->lang->switch_to('polish');

                    //set rules
                    $this->form_validation->set_rules('name',       ucfirst($this->localization['nazwa']), 'required');
                    $this->form_validation->set_rules('lang_id',    ucfirst($this->localization['jezyk']), 'required');
                    $this->form_validation->set_rules('title',      ucfirst($this->localization['tytul']), '');
                    $this->form_validation->set_rules('keywords',   ucfirst($this->localization['slowa_kluczowe']), '');
                    $this->form_validation->set_rules('shortdesc',  ucfirst($this->localization['opis']), '');

                     $content_data['gallery_category_language']['category_id']           = $category_id;
                     $content_data['gallery_category_language']['name']                  = isset($_POST['name'])       ? $_POST['name']        :null;
                     $content_data['gallery_category_language']['lang_id']               = isset($_POST['lang_id'])    ? $_POST['lang_id']     :null;
                     $content_data['gallery_category_language']['title']                 = isset($_POST['title'])      ? $_POST['title']       :null;
                     $content_data['gallery_category_language']['keywords']              = isset($_POST['keywords'])   ? $_POST['keywords']    :null;
                     $content_data['gallery_category_language']['shortdesc']             = isset($_POST['shortdesc'])  ? $_POST['shortdesc']   :null;


                      if ($this->form_validation->run() == TRUE)
                      {
                         if($this->admin_model->update_gallery_category_language( $content_data['gallery_category_language']['id'], $content_data['gallery_category_language']))
                         {
                            $this->messages->add('Operacja została wykonana pomyślnie', 'success');
                            redirect('admin/gallery_categories','location');
                         }
                         else
                         {
                            $this->messages->add('Wystapił bład podczas wprowadzania danych do bazy', 'error');
                         }
                      }
                      else
                          $this->messages->add($this->form_validation->error_string(), 'error');
            }

            $data['content']        = $this->load->view('admin/edit_gallery_category_language', $content_data, true);

            $metatags               = $this->metatags->getValue('cms',$idlang);
            $data['messages']       = $this->messages->get();
            $this->load->view('_shared/layouts/cms/header', $metatags);
            $this->load->view('_shared/layouts/cms/admin',$data);
        }
        //----------------------------------------------------------------------
        //ajax function
        function rearrange_galleries()
        {
           if(!$this->auth->hasAccess('galleries'))
                show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));


           if(!empty($_POST['data_table']))
           {
               $galleries = null;

               $rows = array_reverse($_POST['data_table']);
               foreach($rows as $k=>$v)
               {
                    if($v != "")
                    {
                        $galleries[$k]['idgalleries']  = $v;
                        $galleries[$k]['showorder']    = $k;
                    }
               }
               
               if(!empty($galleries))
                   echo (int)($this->admin_model->update_multiple_galleries($galleries));
           }
        }
        //----------------------------------------------------------------------
        function delete_gallery_category($category_id)
        {
            if(!$this->auth->hasAccess('galleries'))
                    show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));
            
            $category_id = (int)$category_id;
            if($this->admin_model->delete_gallery_category($category_id))
                $this->messages->add('Operacja została wykonana pomyślnie', 'success');
            else
                $this->messages->add('Wystapił bład podczas operacji na bazie danych', 'error');

            redirect('admin/gallery_categories/','location');
        }
        //----------------------------------------------------------------------
        //$idlang - wersja jezykowa galerii,
	function galleries($idlang = 3){
            if(!$this->auth->hasAccess('galleries'))
                    show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

                $content_data['lang_id']            = !empty($_POST['lang_id']) ? $_POST['lang_id']:$idlang;

                $content_data['languages']          = $this->cms->arrayListToDictionary($this->admin_model->get_languages(),'idlanguages','shortname',false);
		$content_data['galleries']          = $this->admin_model->get_galleries();
                //$content_data['gallery_languages']  = $this->admin_model->get_galleries_languages();

		if(!empty($content_data['galleries']))
                {
                    foreach($content_data['galleries'] as $k=>$v)
                        $content_data['galleries'][$k]['category'] = $this->admin_model->get_gallery_categories_language($v['idcategory']);
                }

                $gallery_categories     = $this->admin_model->get_gallery_categories_languages($idlang);
		
		$data               = $this->cms->getMenus('galleries');
		$data['content']    = $this->load->view('admin/galleries', $content_data, true);
		
		$metatags = $this->metatags->getValue('cms',$idlang);
		$this->load->view('_shared/layouts/cms/header', $metatags);
		$this->load->view('_shared/layouts/cms/admin',$data);
	}
	
	function gal_lang_versions($id = null){
                if(!$this->auth->hasAccess('galleries'))
                    show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

		if($id==null){	
			$list['galleries'] = $this->admin_model->get_galleries();
		}else{
			$list['galleries'] = $this->admin_model->get_gal_lang_versions($id);
		}
		$metatags = '';
		
		$data = $this->cms->getMenus('galleries');
		
		//ten widok należy uzależnic od $idlang
		$data['content'] = $this->load->view('admin/galleries', $list, true);
		
		$this->load->view('_shared/layouts/cms/header', $metatags);
		$this->load->view('_shared/layouts/cms/admin',$data);
	}
	
	function delete_gallery($id){
		$allow = $this->auth->hasAccess('galleries'); 
		if($allow){
			$this->admin_model->delete_gallery($id);
		}				
		redirect('/admin/galleries', 'location');		
	}
	
	function add_gallery($idlang = 3){
		$allow = $this->auth->hasAccess('galleries');
		$data = $this->cms->getMenus('galleries');
		if($allow){	
                        $gallery_categories = $this->admin_model->get_gallery_categories_languages($idlang);
                        
                        
                        $data['categories'] = $this->cms->arrayListToDictionary($gallery_categories,'category_id','name');
                        
                        
                        /*
                        if(empty($data['categories']))
                        {
                            $this->messages->add('W systemie nie zdefiniowano kategori, które sa wymagane przy dodawaniu galerii', 'error');
                            redirect('admin/gallery_categories','location');
                        }*/
                        
			if(isset($_POST['title'])){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->cms->generateFriendlyUrl($_POST['friendlyurl']);
				}else{
					if($_POST['title'] != ''){
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['title']);
					}else{
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['name']);
					}
				}
					
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
				
				$gal = array('idgalleries'  => '',
                                             'idcategory'   => isset($_POST['idcategory']) ? (int)$_POST['idcategory'] : null,
                                             'showorder'    => '',
                                             'active'       => $active
				);
				$this->admin_model->add_gallery($gal);				
				//przygotowanie folderu na fotki i miniaturki
				if(mkdir ("./files/img/galleries/".$this->db->insert_id(), 0777))
                                {
					chmod("./files/img/galleries/".$this->db->insert_id(), 0777);	
					mkdir ("./files/img/galleries/".$this->db->insert_id().'/min', 0777);
					chmod("./files/img/galleries/".$this->db->insert_id().'/min', 0777);

					$gal_lang=array('idgalleries_languages' => '',
								'idgalleries'   => $this->db->insert_id(),
								'idlanguages'   => $_POST['idlanguage'], 
								'name'          => $_POST['name'],
								'content'       => $_POST['artcontent'],
                                                                'url'           => $_POST['url'],
								'title'         => $_POST['title'],
								'keywords'      => $_POST['keywords'],
								'shortdesc'     => $_POST['shortdesc'],
								'abstract'      => $_POST['abstract'],
								'subject'       => $_POST['subject'],
                                                                'topic'         => $_POST['topic'],
								'copyrights'    => $_POST['copyrights'],
								'friendlyurl'   => $friendlyurl
					);
					$this->admin_model->add_gallery_language($gal_lang);
				}else{
					$this->admin_model->delete_gallery($this->db->insert_id());
				}
				redirect('/admin/galleries', 'location');	
			}else{
				//przygotowanie listy jezykow do boxa
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$bufor1[$i]=$lang['idlanguages'];
					$bufor2[$i]=$lang['shortname'];		
					$i++;								
				}
				$data['languages']=array_combine($bufor1,$bufor2);			
				$data['content'] = $this->load->view('admin/add_gallery', $data, true);
				
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}

	function edit_gallery($id=null, $idlang = 3){
		$allow = $this->auth->hasAccess('galleries'); 
		if($allow){
                        $gallery_categories = $this->admin_model->get_gallery_categories();
                        $data['categories'] = $this->cms->arrayListToDictionary($gallery_categories,'id','name');

			if(isset($_POST['title'])){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->cms->generateFriendlyUrl($_POST['friendlyurl']);
				}else{
					if($_POST['title'] != ''){
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['title']);
					}else{
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['name']);
					}
				}
					
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}

				$gal = array(
                                             'idcategory'   => isset($_POST['idcategory']) ? (int)$_POST['idcategory'] : null,
				);
				$this->admin_model->update_gallery($id,$gal);
												
				$gal_lang=array('idgalleries_languages' => $_POST['idgalleries_languages'],
							'idgalleries' => $id,
							'idlanguages' => $_POST['idlanguage'],
							'name' => $_POST['name'],
							'content' => $_POST['artcontent'],
							'title' => $_POST['title'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->update_gallery_language($gal_lang['idgalleries_languages'], $gal_lang);
				redirect('/admin/galleries', 'location');	
			}else{
				$gallery = $this->admin_model->get_gallery_by_id($id,$idlang);
				if(isset($gallery[0])){
					$gallery = $gallery[0];
					$data = array(
							'idgalleries' => $gallery['idgalleries'],
                                                        'idcategory'  => $gallery['idcategory'],
							'active' => $gallery['active'],
							'idgalleries_languages' => $gallery['idgalleries_languages'],
							'idlanguages' => $gallery['idlanguages'],
							'title' => $gallery['title'],
							'content' => $gallery['content'],
							'titleseo' => $gallery['titleseo'],
							'keywords' => $gallery['keywords'],
							'shortdesc' => $gallery['shortdesc'],
							'abstract' => $gallery['abstract'],
							'subject' => $gallery['subject'],
							'topic' => $gallery['topic'],
							'copyrights' => $gallery['copyrights'],
							'friendlyurl' => $gallery['friendlyurl']
						);
					
					//przygotowanie listy jezykow do boxa
					$languages = $this->admin_model->get_languages();
					$bufor1	=	array($gallery['idlanguages']);
					$bufor2	=	array('-----');
					$i = 1;
					foreach($languages as $lang){
						$bufor1[$i]=$lang['idlanguages'];
						$bufor2[$i]=$lang['shortname'];
						$i++;
					}
					$data['languages']=array_combine($bufor1,$bufor2);
				}
				$cus = $this->cms->getMenus('galleries');
				$data['menu_poziom'] = $cus['menu_poziom'];
				$data['menu_pion'] =$cus['menu_pion'];		
				
				$data['content'] = $this->load->view('admin/edit_gallery', $data, true);
				
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}
	
	function delete_gallery_language($idgal, $idgal_lang){
		$allow = $this->auth->hasAccess('galleries'); 
		if($allow){
			$this->admin_model->delete_gallery_language($idgal_lang);
			$bufor = $this->admin_model->get_gal_lang_versions($idgal);
			if(!isset($bufor[0])){
				$data = $this->admin_model->get_data_to_delete_gallery($idgal);
				if(isset($data[0])){
					foreach($data as $img_lang){
						$this->admin_model->delete_image_language($img_lang['idimages_languages']);
					}
					foreach($data as $img){
						$this->admin_model->delete_image($img['idimages']);
					}
				}
				$this->admin_model->delete_gallery($idgal);
				$this->cms->full_rmdir('./files/img/galleries/'.$idgal);
			}
		}
		redirect('/admin/galleries', 'location');		
	}
	
	function add_gallery_language($id=null, $idlang = 3){
		$allow = $this->auth->hasAccess('galleries'); 
		$data = $this->cms->getMenus('galleries');
		if($allow){			
			if(isset($_POST['title']) && $id != null){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->cms->generateFriendlyUrl($_POST['friendlyurl']);
				}else{
					if($_POST['title'] != ''){
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['title']);
					}else{
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['name']);
					}
				}	
					
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
												
				$gal_lang=array('idgalleries_languages' => '',
							'idgalleries' => $id,
							'idlanguages' => $_POST['idlanguage'],
							'name' => $_POST['name'],
							'content' => $_POST['artcontent'],
                                                        'url' => $_POST['url'],
							'title' => $_POST['title'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->add_gallery_language($gal_lang);
				redirect('/admin/galleries', 'location');	
			}else{
				//przygotowanie listy jezykow do boxa
				$used_langs = $this->admin_model->get_gal_lang_versions($id);
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$flag = 1;
					foreach($used_langs as $used_lang){
						if($lang['idlanguages'] == $used_lang['idlanguages'])
						{
							$flag = 0;
							break;
						}
					}
					if($flag){
						$bufor1[$i]=$lang['idlanguages'];
						$bufor2[$i]=$lang['shortname'];
						$i++;
					}
				}
				if($bufor1!=array() && $bufor2!=array()){			
					$data['languages']=array_combine($bufor1,$bufor2);
					$data['id'] = $id;
					$data['idlang'] = $idlang;		
					$data['meta'] = $this->metatags->getValue('gallery',$idlang);
					$data['content'] = $this->load->view('admin/add_gallery_language', $data, true);
				}else{
					$data['content'] = $this->localization['wszystkie_wersje_dostepne'];
				}
				
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}				
	}

	function edit_gallery_language($idgal_lang, $idgal, $idlang){
		$allow = $this->auth->hasAccess('galleries'); 
		if($allow){
                        
                        $gallery_categories = $this->admin_model->get_gallery_categories_languages($idlang);
                        $data['categories'] = $this->cms->arrayListToDictionary($gallery_categories,'category_id','name');
                        
                        
			if(isset($_POST['name'])){


				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->cms->generateFriendlyUrl($_POST['friendlyurl']);
				}else{
					if($_POST['title'] != ''){
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['title']);
					}else{
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['name']);
					}
				}	
					
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}

				$gal = array(
                                             'idcategory'   => $_POST['idcategory'],
				);
				$this->admin_model->update_gallery($idgal,$gal);
												
				$gal_lang=array('name' => $_POST['name'],
							'content' => $_POST['artcontent'],
							'title' => $_POST['title'],
                                                        'url' => $_POST['url'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->update_gallery_language($idgal_lang, $gal_lang);
				//redirect($_SERVER['HTTP_REFERER'], 'location');
                                redirect('/admin/galleries', 'location');
			}else{
				$gallery = $this->admin_model->get_gallery_by_id($idgal,$idlang);
				if(isset($gallery[0])){
					$gallery = $gallery[0];
					$data = array(
							'idgalleries_languages' => $gallery['idgalleries_languages'],
							'active'        => $gallery['active'],
							'idlanguages'   => $gallery['idlanguages'],
                                                        'idcategory'    => $gallery['idcategory'],
							'name'      => $gallery['name'],
							'content' => $gallery['content'],
                                                        'url' => $gallery['url'],
							'title' => $gallery['title'],
							'keywords' => $gallery['keywords'],
							'shortdesc' => $gallery['shortdesc'],
							'abstract' => $gallery['abstract'],
							'subject' => $gallery['subject'],
							'topic' => $gallery['topic'],
							'copyrights' => $gallery['copyrights'],
							'friendlyurl' => $gallery['friendlyurl']
						);
						
					//przygotowanie listy jezykow do boxa
					$languages = $this->admin_model->get_languages();
					$bufor1	=	array($gallery['idlanguages']);
					$bufor2	=	array('-----');
					$i = 1;
					foreach($languages as $lang){
						$bufor1[$i]=$lang['idlanguages'];
						$bufor2[$i]=$lang['shortname'];
						$i++;
					}
					$data['languages']=array_combine($bufor1,$bufor2);
				}
                                $data['categories'] = $this->cms->arrayListToDictionary($gallery_categories,'id','name');
				$data['idgal_lang'] = $idgal_lang;
				$data['idgal'] = $idgal;
				$data['idlang'] = $idlang;		
				
				
				$cus = $this->cms->getMenus('galleries');
				$data['menu_pion'] = $cus['menu_pion'];
				$data['menu_poziom'] = $cus['menu_poziom'];
				$data['content'] = $this->load->view('admin/edit_gallery_language', $data, true);
				
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}				
	}

	function change_gallery_priority($id){
		$allow = $this->auth->hasAccess('galleries');
		if($allow){
			$showorder = $_POST['priority'];
			$data=array( 'showorder' => $showorder);
			$this->admin_model->update_gallery($id, $data);
		}		
		redirect('/admin/galleries', 'location');		
	}

//images
	function show_gallery($id, $idlang=3){
                if(!$this->auth->hasAccess('images'))
                    show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

                $content_data['idgalleries']     =  $id;
                $content_data['lang_id']         =  !empty($_POST['lang_id']) ? $_POST['lang_id'] : $idlang;
                $content_data['languages']       =  $this->cms->arrayListToDictionary($this->admin_model->get_languages(),'idlanguages','shortname',false);
                $content_data['categories']      =  $this->admin_model->get_gallery_categories();
                $content_data['gallery']         =  $this->frontside_model->get_gallery_by_id($id, $idlang);

                $data                   = $this->cms->getMenus('images');
                
                if(isset($content_data['gallery'][0]))
                {
                    $content_data['gallery']     =   $content_data['gallery'][0];
                    $content_data['images']          =  $this->admin_model->get_gallery_images($id);
                    $content_data['image_languages'] =  $this->admin_model->get_img_lang_versions();
                    
                    $data['content'] = $this->load->view('admin/show_gallery', $content_data, true);
                }
                else
                {
                    $this->messages->add('Wskazana galeria nie posiada żadanej wersji jezykowej', 'error');
                    $data['content'] = '';
                }


                
		
                $data['messages']       = $this->messages->get();

                $metatags = $this->metatags->getValue('cms',$idlang);
		$this->load->view('_shared/layouts/cms/header', $metatags);
		$this->load->view('_shared/layouts/cms/admin',$data);
	}	

        //--------------------------------------------------------------------------
        //ajax function
        function rearrange_images()
        {
           if(!$this->auth->hasAccess('images'))
                show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));


           if(!empty($_POST['data_table']))
           {
               $images = null;

               $rows = array_reverse($_POST['data_table']);
               foreach($rows as $k=>$v)
               {
                    if($v != "")
                    {
                        $images[$k]['idimages']       = $v;
                        $images[$k]['showorder']    = $k;
                    }
               }

               if(!empty($images))
                   echo (int)($this->admin_model->update_multiple_images($images));
           }
        }

	function add_image($idgal, $idlang = 3){
		$allow = $this->auth->hasAccess('images');
		$data = $this->cms->getMenus('images');
		if($allow){			
			if(isset($_POST['title']) && isset($_FILES['file']['name']) && $_FILES['file']['name']!=''){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->cms->generateFriendlyUrl($_POST['friendlyurl']);
				}else{
					if($_POST['title'] != ''){
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['title']);
					}else{
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['name']);
					}
				}
					
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
				
				//dodawanie obrazka
				//uploadowanie pliku
				$config['upload_path'] = './files/img/galleries/'.$idgal;
				$config['allowed_types'] = 'gif|jpg|png';
				$config['remove_spaces'] = TRUE;		
				
				$this->load->library('upload', $config);
				$this->upload->do_upload('file');
				$file_data = $this->upload->data();
				//zmiana praw pliku
				chmod('./files/img/galleries/'.$idgal.'/'.$file_data['file_name'], 0777);
				//tworzenie miniaturki
				$img_config['image_library'] = 'gd2';
				$img_config['source_image'] = './files/img/galleries/'.$idgal.'/'.$file_data['file_name'];
				$img_config['new_image'] = './files/img/galleries/'.$idgal.'/min/';
				$img_config['maintain_ratio'] = TRUE;
				$img_config['width'] = $this->gal_img['width'];
				$img_config['height'] = $this->gal_img['height'];
				$this->load->library('image_lib', $img_config);
				$this->image_lib->resize();
				if ( ! $this->image_lib->resize()){
				    echo $this->image_lib->display_errors();
				}	
					
				
				$gal = array('idimages' => '',
							'idgalleries' => $idgal,
							'path'	=> $file_data['file_name'],
							'active' => $active	
				);
				
				$this->admin_model->add_image($gal);				
				$gal_lang=array('idimages_languages' => '',
							'idimages' => $this->db->insert_id(),
							'idlanguages' => $_POST['idlanguage'],
							'name' => $_POST['name'],
							'content' => $_POST['artcontent'],
							'title' => $_POST['title'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->add_image_language($gal_lang);
				redirect($_SERVER['HTTP_REFERER'], 'location');	
			}else{
				//przygotowanie metatagów
				$gal_data = $this->admin_model->get_gallery_by_id($idgal, $idlang);
				if(isset($gal_data[0])){
					$data['metatags'] = $gal_data[0];					
				}else{
					$data['metatags'] = array('title' => '',
					'name' => '',
					'artcontent' => '',
					'keywords' => '',
					'shortdesc' => '',
					'abstract' => '',
					'subject' => '',
					'topic' => '',
					'copyrights' => '',
					'friendlyurl' => ''
					);
				}
				//przygotowanie listy jezykow do boxa
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$bufor1[$i]=$lang['idlanguages'];
					$bufor2[$i]=$lang['shortname'];
					$i++;
				}
				$data['languages'] = array_combine($bufor1,$bufor2);
				$data['idgal'] = $idgal;
				$data['idlang'] = $idlang;				
				$data['meta'] = $this->metatags->getValue('image',$idlang);
				$data['content'] = $this->load->view('admin/add_img', $data, true);
				
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}
	
	function add_multiimage($idgal, $idlang = 3){
		//$allow = $this->check_login('images', '', true);
		//if($allow){
        //
            $fileName = $_FILES['Filedata']['name'];
            $fileName = date("Y_m_d-H_i_s_u").".jpg";

			//dodawanie obrazka
			move_uploaded_file($_FILES['Filedata']['tmp_name'], './files/img/galleries/'.$idgal.'/'.$fileName);
			//zmiana praw pliku
			chmod('./files/img/galleries/'.$idgal.'/'.$fileName, 0777);
			//tworzenie miniaturki
			$img_config['image_library'] = 'GD2';
			$img_config['source_image'] = './files/img/galleries/'.$idgal.'/'.$fileName;
			$img_config['new_image'] = './files/img/galleries/'.$idgal.'/min/';
			$img_config['maintain_ratio'] = true;
			$img_config['width']    = $this->gal_img['width'];
			$img_config['height']   = $this->gal_img['height'];
                        
			$this->load->library('image_lib', $img_config);
			$this->image_lib->resize();
			if ( ! $this->image_lib->resize()){
			    echo $this->image_lib->display_errors();
			}	
				
			$gal = array('idimages' => '',
						'idgalleries' => $idgal,
						'path'	=> $fileName,
						'active' => true	
			);
			
			$this->admin_model->add_image($gal);

            $title = explode(".",$_FILES['Filedata']['name']); //default
            if(isset($title[0]))
                $title = ucfirst($title[0]);
            else
                $title = "";

            $lastDotIndex = strripos($_FILES['Filedata']['name'], '.');
            if($lastDotIndex > 0)
                $title = ucfirst(substr($_FILES['Filedata']['name'],0,$lastDotIndex));


                $image_id = $this->db->insert_id();

                $langs                  = (array)$this->admin_model->get_languages();
                if(!empty($langs) && is_array($langs))
                {
                    foreach($langs as $k=>$v)
                    {
                        $gal_lang=array('idimages_languages'    => '',
                                                'idimages'      => $image_id,
                                                'idlanguages'   => (int)$v['idlanguages'],
                                                'name'          => $title,
                                                'content'       => '',
                                                'title'         => '',
                                                'keywords'      => '',
                                                'shortdesc'     => '',
                                                'abstract'      => '',
                                                'subject'       => '',
                                                'topic'         => '',
                                                'copyrights'    => '',
                                                'friendlyurl'   => ''
                        );
                        $this->admin_model->add_image_language($gal_lang);
                    }
                }
	}
	
	function add_image_language($id=null, $idgal=null, $idlang = 3){
		$allow = $this->auth->hasAccess('images');
		$data = $this->cms->getMenus('images');
		if($allow){			
			if(isset($_POST['title']) && $id != null){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->cms->generateFriendlyUrl($_POST['friendlyurl']);
				}else{
					if($_POST['title'] != ''){
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['title']);
					}else{
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['name']);
					}
				}
					
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
												
				$gal_lang=array('idimages_languages' => '',
							'idimages'      => $id,
							'idlanguages'   => $_POST['idlanguage'],
							'name'          => $_POST['name'],
							'content'       => $_POST['artcontent'],
							'title'         => $_POST['title'],
							'keywords'      => $_POST['keywords'],
							'shortdesc'     => $_POST['shortdesc'],
							'abstract'      => $_POST['abstract'],
							'subject'       => $_POST['subject'],
							'topic'         => $_POST['topic'],
							'copyrights'    => $_POST['copyrights'],
							'friendlyurl'   => $friendlyurl
				);
				$this->admin_model->add_image_language($gal_lang);
				redirect($_SERVER['HTTP_REFERER'], 'location');	
			}else{
				//przygotowanie listy jezykow do boxa
				$used_langs = $this->admin_model->get_img_lang_versions_by_id($id);
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$flag = 1;
					foreach($used_langs as $used_lang){
						if($lang['idlanguages'] == $used_lang['idlanguages'])
						{
							$flag = 0;
							break;
						}
					}
					if($flag){
						$bufor1[$i]=$lang['idlanguages'];
						$bufor2[$i]=$lang['shortname'];
						$i++;
					}
				}
				if($bufor1!=array() && $bufor2!=array()){			
					$data['languages']=array_combine($bufor1,$bufor2);
					$data['id'] = $id;
					$data['idgal'] = $idgal;	
					$data['idlang'] = $idlang;		
					$data['meta'] = $this->metatags->getValue('image',$idlang);
					$data['content'] = $this->load->view('admin/add_image_language', $data, true);
				}else{
					$data['content'] = $this->localization['wszystkie_wersje_dostepne'];
				}
				
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}				
	}

	function delete_image_language($idimg_lang, $idimg, $idgal, $idlang=3){
		$allow = $this->auth->hasAccess('images');
		if($allow){
			$this->admin_model->delete_image_language($idimg_lang);
			
			$bufor = $this->admin_model->get_img_lang_versions_by_id($idimg);
			//print_r($bufor);
			if(!isset($bufor[0])){
				$image = $this->admin_model->get_image_by_id($idimg);
				if(isset($image[0])){
					$this->admin_model->delete_image($idimg);
					@unlink("./files/img/galleries/".$idgal.'/'.$image[0]['path']);
					@unlink("./files/img/galleries/".$idgal.'/min/'.$image[0]['path']);
				}
			}
		}				
		redirect('/admin/show_gallery/'.$idgal.'/'.$idlang, 'location');		
	}

    function edit_gallery_min_image()
    {
        if(empty($_POST['idimages']) || empty($_FILES['min_image']['name']))
        {
            if(empty($_POST['return_url']))
                redirect("admin");
            else
                redirect($_POST['return_url']);
        }

        $idimages   = (int)$_POST['idimages'];
        $image      = $this->admin_model->get_image_by_id($idimages);
        
        if(!empty($image) && is_array($image))
        {
            $image = $image[0];
            $idgalleries = $image['idgalleries'];
            @unlink("./files/img/galleries/".$idgalleries."/min/".$image['path']);

            $config['upload_path'] = './files/img/galleries/'.$idgalleries.'/min/';
            $config['allowed_types'] = 'gif|jpg|png';
            $config['remove_spaces'] = TRUE;

            $this->load->library('upload', $config);
            if(!$this->upload->do_upload('min_image'))
                echo $this->upload->display_errors();
            
            $file_data = $this->upload->data();

            //zmiana praw pliku
            chmod('./files/img/galleries/'.$idgalleries.'/min/'.$file_data['file_name'], 0777);
            rename('./files/img/galleries/'.$idgalleries.'/min/'.$file_data['file_name'], './files/img/galleries/'.$idgalleries.'/min/'.$image['path']);

        }
        redirect($_POST['return_url']);
    }

	function edit_image_language($idimg_lang, $idgal, $idlang){
		$allow =  $this->auth->hasAccess('images');
		if($allow){			
			if(isset($_POST['title'])){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->cms->generateFriendlyUrl($_POST['friendlyurl']);
				}else{
					if($_POST['title'] != ''){
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['title']);
					}else{
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['name']);
					}
				}
															
				$gal_lang=array('idimages_languages' => $idimg_lang,
							'idlanguages' => $_POST['idlanguage'],
							'name' => $_POST['name'],
							'content' => $_POST['artcontent'],
							'title' => $_POST['title'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->update_image_language($gal_lang['idimages_languages'], $gal_lang);
				//redirect($_SERVER['HTTP_REFERER'], 'location');
                                redirect('/admin/show_gallery/'.$idgal.'/'.$idlang, 'location', 301);
			}else{
				$image = $this->admin_model->get_image_lang_by_id($idimg_lang);
				if(isset($image[0])){
					$image = $image[0];
					$data = array(
							'idimages_languages' => $image['idimages_languages'],
							'active' => $image['active'],
							'idimages_languages' => $image['idimages_languages'],
							'idlanguages' => $image['idlanguages'],
							'name' => $image['name'],
							'content' => $image['content'],
							'title' => $image['title'],
							'keywords' => $image['keywords'],
							'shortdesc' => $image['shortdesc'],
							'abstract' => $image['abstract'],
							'subject' => $image['subject'],
							'topic' => $image['topic'],
							'copyrights' => $image['copyrights'],
							'friendlyurl' => $image['friendlyurl']
						);
									
					//przygotowanie listy jezykow do boxa
					$languages = $this->admin_model->get_languages();
					$bufor1=array($image['idlanguages']);
					$bufor2=array('-----');
					$i = 1;
					foreach($languages as $lang){
						$bufor1[$i]=$lang['idlanguages'];
						$bufor2[$i]=$lang['shortname'];
						$i++;
					}
					$data['languages']=array_combine($bufor1,$bufor2);
				}
				$cus = $this->cms->getMenus('images');
				$data['menu_poziom'] = $cus['menu_poziom'];
				$data['menu_pion'] =$cus['menu_pion'];
				$data['idgallery'] = $idgal;	
				$data['idlang'] = $idlang;		
				$data['content'] = $this->load->view('admin/edit_image', $data, true);
				
				$group = $this->session->userdata('group');
				
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}

	function change_image_priority($id, $idgal){
		$allow =   $this->auth->hasAccess('images'); 
		if($allow){
			$showorder = $_POST['priority'];
			$data=array( 'showorder' => $showorder);
			$this->admin_model->update_image($id, $data);
		}		
		redirect($_SERVER['HTTP_REFERER'], 'location');		
	}

//metatagi
	function metatags($idlang = 3){

                if(!$this->auth->hasAccess('metatags'))
                    show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

		$list['metatags']   = $this->admin_model->get_metatags();
		$list['languages']  = $this->admin_model->get_languages();
		$list['types']      = $this->admin_model->get_metatag_types();
		
		$data = $this->cms->getMenus('metatags');
                $content = $this->load->view('admin/metatags', $list, true);
                
		$data['content'] = $content;
		
		$metatags = $this->metatags->getValue('cms',$idlang);
		$this->load->view('_shared/layouts/cms/header', $metatags);
		$this->load->view('_shared/layouts/cms/admin',$data);
	}
	
	function add_metatag( $idlang = 3){
		$allow =   $this->auth->hasAccess('metatags'); 

		$data = $this->cms->getMenus('metatags');
		if($allow){			
			if(isset($_POST['title']) && $_POST['title'] != ''){
				$data=array('idmetatags' => '',
							'idmetatag_types' => $_POST['idmetatag_types'],
							'idlanguages' => $_POST['idlanguage'],
							'template' => $_POST['name'],
							'title' => $_POST['title'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights']
				);
				$this->admin_model->add_metatags($data);
				unset($_POST);
				redirect('/admin/metatags', 'location');	
			}else{
				//przygotowanie listy jezykow do boxa
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$bufor1[$i]=$lang['idlanguages'];
					$bufor2[$i]=$lang['shortname'];
					$i++;
				}
				if($bufor1!=array() && $bufor2!=array()){			
					$data['languages']=array_combine($bufor1,$bufor2);			
				}
				
				//szablony do boxa
				$types = $this->admin_model->get_metatag_types();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($types as $type){
					$bufor1[$i]=$type['idmetatag_types'];
					$bufor2[$i]=$type['name'];
					$i++;
				}
				if($bufor1!=array() && $bufor2!=array()){			
					$data['types']=array_combine($bufor1,$bufor2);			
				}
				
				$data['content'] = $this->load->view('admin/add_metatag', $data, true);
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}
	
	function edit_metatag($id = null,$idlang = 3){
		$allow =   $this->auth->hasAccess('metatags'); 
		$data = $this->cms->getMenus('metatags');
		if($allow){			
			if(isset($_POST['title']) && $_POST['title'] != ''){
				$data=array('idmetatags' => $id,
							'idlanguages' => $_POST['idlanguage'],
							'title' => $_POST['title'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights']
				);
				$this->admin_model->update_metatag($id,$data);
				unset($_POST);
				redirect('/admin/metatags', 'location');	
			}else{
				$meta = $this->admin_model->get_metatag_by_id($id);
				$meta = $meta[0];
				$data['metatag'] = array('idmetatags' => $id,
										'idlanguages' => $meta['idlanguages'],
										'title' => $meta['title'],
										'keywords' => $meta['keywords'],
										'shortdesc' => $meta['shortdesc'],
										'abstract' => $meta['abstract'],
										'subject' => $meta['subject'],
										'topic' => $meta['topic'],
										'copyrights' => $meta['copyrights']
								);
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$bufor1[$i]=$lang['idlanguages'];
					$bufor2[$i]=$lang['shortname'];
					$i++;
				}				
				$data['languages'] = array_combine($bufor1,$bufor2);
				
				$data['id']= $id;
				$data['content'] = $this->load->view('admin/edit_metatag', $data, true);
				
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}
	
	function delete_metatags($id = null){
		$allow =   $this->auth->hasAccess('metatags'); 
		if($allow){
			if($id != null){
				$this->admin_model->delete_metatags($id);
			}
		}		
		redirect('/admin/metatags', 'location');		
	}

//newses	
	function newses($idlang = 3){
                if(!$this->auth->hasAccess('newses'))
                        show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

		$list['newses'] = $this->admin_model->get_newses();
		$list['news_languages'] = $this->admin_model->get_news_languages();
		
		$data = $this->cms->getMenus('newses');
		$data['content'] = $this->load->view('admin/newses', $list, true);
		
		$metatags = $this->metatags->getValue('cms',$idlang);
		$this->load->view('_shared/layouts/cms/header', $metatags);
		$this->load->view('_shared/layouts/cms/admin',$data);
	}
	
	function change_news_priority($id){
		$allow = $this->auth->hasAccess('newses');
		if($allow){
			$showorder = $_POST['priority'];
			$data=array( 'showorder' => $showorder);
			$this->admin_model->update_news($id, $data);
		}				
		
		redirect('/admin/newses', 'location');		
	}

	function delete_news_language($idnews, $idnews_language){
		$allow = $this->auth->hasAccess('newses');
		if($allow){
			$this->admin_model->delete_news_language($idnews_language);
			$data = $this->admin_model->get_news_languages_by_idnewses($idnews);
			if(!isset($data[0])){
				$photo = $this->admin_model->get_newses_by_id($idnews);
				if(isset($photo[0]['image']) && $photo[0]['image'] != ''){
					unlink('./files/img/newses/'.$photo[0]['image']);
					unlink('./files/img/newses/min/'.$photo[0]['image']);					
				}
				$this->admin_model->delete_news($idnews);	
			}
		}
		redirect('/admin/newses', 'location');		
	}
	
	function add_news($idlang = 3){
		$allow = $this->auth->hasAccess('newses');
		$data   = $this->cms->getMenus('newses');

		if($allow){			
			if(isset($_POST['title']) && $_POST['title'] != ''){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->cms->generateFriendlyUrl($_POST['friendlyurl']);
				}else{
					if($_POST['title'] != ''){
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['title']);
					}else{
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['name']);
					}
				}
				
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
				$file_data = array('file_name' => ''); 	
				if(isset($_FILES['file']) && $_FILES['file']['name']!=''){
					//uploadowanie pliku
					$config['upload_path'] = './files/img/newses/';
					$config['allowed_types'] = 'gif|jpg|png';
					$config['remove_spaces'] = TRUE;		
					
					$this->load->library('upload', $config);
					$this->upload->do_upload('file');
					$file_data = $this->upload->data();
					//zmiana praw pliku
					chmod('./files/img/newses/'.$file_data['file_name'], 0777);
					//tworzenie miniaturki
					$img_config['image_library'] = 'gd2';
					$img_config['source_image'] = './files/img/newses/'.$file_data['file_name'];
					$img_config['new_image'] = './files/img/newses/min/';
					$img_config['maintain_ratio'] = TRUE;
					$img_config['width'] = $this->news['width'];
					$img_config['height'] = $this->news['height'];
					$this->load->library('image_lib', $img_config);
					$this->image_lib->resize();
					if ( ! $this->image_lib->resize()){
					    echo $this->image_lib->display_errors();
					}	
				}
				
				$data=array('idnewses' => '',
							'image' => $file_data['file_name'],
							'date' => date('c'),
							'showorder' => '',
							'active' => $active
				);
				$this->admin_model->add_news($data);
				$data=array('idnews_languages' => '',
							'idnewses' => $this->db->insert_id(),
							'idlanguages' => $_POST['idlanguage'],
							'name' => $_POST['name'],
							'content' => $_POST['artcontent'],
							'title' => $_POST['title'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->add_news_language($data);
				redirect('/admin/newses', 'location');	
			}else{
				//przygotowanie listy jezykow do boxa
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$bufor1[$i]=$lang['idlanguages'];
					$bufor2[$i]=$lang['shortname'];
					$i++;
				}
				$data['languages']=array_combine($bufor1,$bufor2);		
				$data['meta'] = $this->metatags->getValue('frontside',$idlang);
				$data['content'] = $this->load->view('admin/add_news', $data, true);
				
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}
	
	function add_news_language($id_newses, $idlang = 3){
		$allow = $this->auth->hasAccess('newses');
		$data = $this->cms->getMenus('newses');
		if($allow){			
			if(isset($_POST['title']) && $_POST['title'] != ''){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->cms->generateFriendlyUrl($_POST['friendlyurl']);
				}else{
					if($_POST['title'] != ''){
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['title']);
					}else{
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['name']);
					}
				}
				
				$data=array('idnews_languages' => '',
							'idnewses' => $id_newses,
							'idlanguages' => $_POST['idlanguage'],
							'name' => $_POST['name'],
							'content' => $_POST['artcontent'],
							'title' => $_POST['title'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->add_news_language($data);
				redirect('/admin/newses', 'location');	
			}else{
				$data['id_newses'] = $id_newses;
				//przygotowanie listy jezykow do boxa
				//przygotowanie listy jezykow do boxa
				$used_langs = $this->admin_model->get_news_languages_by_idnewses($id_newses);
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$flag = 1;
					foreach($used_langs as $used_lang){
						if($lang['idlanguages'] == $used_lang['idlanguages'])
						{
							$flag = 0;
							break;
						}
					}
					if($flag){
						$bufor1[$i]=$lang['idlanguages'];
						$bufor2[$i]=$lang['shortname'];
						$i++;
					}
				}	
				if($bufor1!=array() && $bufor2!=array()){			
					$data['languages']=array_combine($bufor1,$bufor2);		
					$data['meta'] = $this->metatags->getValue('news',$idlang);
					$data['content'] = $this->load->view('admin/add_news_language', $data, true);
				}else{
					$data['content'] = $this->localization['wszystkie_wersje_dostepne'];
				}
				
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}

	function edit_news_language($idnews_languages, $idlang = 3){
		if($idnews_languages != null){
			$allow = $this->auth->hasAccess('newses');
			$data2 = $this->cms->getMenus('newses');
			if($allow){			
				if(isset($_POST['name']) && $_POST['name'] != ''){
					if($_POST['friendlyurl'] != ''){
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['friendlyurl']);
					}else{
						if($_POST['title'] != ''){
							$friendlyurl = $this->cms->generateFriendlyUrl($_POST['title']);
						}else{
							$friendlyurl = $this->cms->generateFriendlyUrl($_POST['name']);
						}
					}
					
					$active = false;
					if(isset($_POST['active'])){
						$active = true;
					}
					if(isset($_FILES) && $_FILES['file']['name']!=''){
						$photo = $this->admin_model->get_newses_by_id($_POST['idnewses']);
						if(isset($photo[0]) && $photo[0]['image']!=''){
							unlink('./files/img/newses/'.$photo[0]['image']);
							unlink('./files/img/newses/min/'.$photo[0]['image']);
						}
						//uploadowanie pliku
						$config['upload_path'] = './files/img/newses/';
						$config['allowed_types'] = 'gif|jpg|png';
						$config['remove_spaces'] = TRUE;		
						
						$this->load->library('upload', $config);
						$this->upload->do_upload('file');
						$file_data = $this->upload->data();
						
						//tworzenie miniaturki
						$img_config['image_library'] = 'GD2';
						$img_config['source_image'] = './files/img/newses/'.$file_data['file_name'];
						$img_config['new_image'] = './files/img/newses/min/';
						$img_config['maintain_ratio'] = TRUE;
						$img_config['width'] = $this->news['width'];
						$img_config['height'] = $this->news['height'];
						$this->load->library('image_lib', $img_config);
						$this->image_lib->resize();
						if ( ! $this->image_lib->resize()){
						    echo $this->image_lib->display_errors();
						}	
						$data = array('image'=> $file_data['file_name']);
						$this->admin_model->update_news($_POST['idnewses'], $data);
					}
					
					$data=array('active' => $active);
					$this->admin_model->update_news($_POST['idnewses'], $data);
					
					$data=array('idlanguages' => $_POST['idlanguage'],
								'name' => $_POST['name'],
								'content' => $_POST['artcontent'],
								'title'     => $_POST['title'],
								'keywords'  => $_POST['keywords'],
								'shortdesc' => $_POST['shortdesc'],
								'abstract' => $_POST['abstract'],
								'subject' => $_POST['subject'],
								'topic' => $_POST['topic'],
								'copyrights' => $_POST['copyrights'],
								'friendlyurl' => $friendlyurl
					);
					$this->admin_model->update_news_language($idnews_languages, $data);
					
					redirect('/admin/newses', 'location');	
				}else{
					//przygotowanie danych
					$news = $this->admin_model->get_news_lang_by_id($idnews_languages);
					if(isset($news[0])){
						$news = $news[0];	
						
						$data = array(	'idnews_languages' => $idnews_languages,
										'idnewses' => $news['idnewses'],
										'name' => $news['name'],
										'content' => $news['content'],
										'title' => $news['title'],
										'keywords' => $news['keywords'],
										'shortdesc' => $news['shortdesc'],
										'abstract' => $news['abstract'],
										'subject' => $news['subject'],
										'topic' => $news['topic'],
										'copyrights' => $news['copyrights'],
										'friendlyurl' => $news['friendlyurl'],
										'active' => $news['active']
									);		
						
						//przygotowanie listy jezykow do boxa
						$languages = $this->admin_model->get_languages();
						$bufor1=array($news['idlanguages']);
						$bufor2=array('---');
						$i = 1;
						foreach($languages as $lang){
							$bufor1[$i]=$lang['idlanguages'];
							$bufor2[$i]=$lang['shortname'];
							$i++;
						}
						$data['languages']=array_combine($bufor1,$bufor2);
						
						
						$data2['content'] = $this->load->view('admin/edit_news_language', $data, true);
						
						$metatags = $this->metatags->getValue('cms',$idlang);
						$this->load->view('_shared/layouts/cms/header', $metatags);
						$this->load->view('_shared/layouts/cms/admin',$data2);
					}else{
						redirect($_SERVER['HTTP_REFERER'], 'location');
					}
				}
			}		
		}else{
			redirect('/admin/newses', 'location');
		}
	}

//articles	
	function articles($idlang = 3){	
		$list['language'] = $this->set_language($idlang);
		$list['articles'] = $this->admin_model->get_articles();

		$list['article_languages'] = $this->admin_model->get_article_languages();
		$list['site'] = $this->localization;

		//przygotowanie listy jezykow do boxa
		$languages = $this->admin_model->get_languages();
		$i = 0;
		foreach($languages as $lang){
			$bufor1[$i]=$lang['idlanguages'];
			$bufor2[$i]=$lang['fullname'];
			$i++;
		}
		$list['languages'] = array_combine($bufor1,$bufor2);

                //przygotowanie listy gallerii
		$galleries = $this->admin_model->get_galleries();
		$galleries_languages = $this->admin_model->get_galleries_languages();
		$list['galleries'] = array(''=>'');
		foreach($galleries as $gallery){
			foreach($galleries_languages as $galleries_language){
				if($gallery['idgalleries'] == $galleries_language['idgalleries']){
					$list['galleries'][$gallery['idgalleries']] = $galleries_language['title'];
					break;
				}
			}
		}

                //przygotowane listy
		$list['lists']      = $this->list_model->getParents();
                $list['messages']   = $this->messages->get();

		$data = $this->cms->getMenus('articles');
		$content = $this->load->view('admin/articles', $list, true);

                if($this->auth->hasAccess('articles'))
                    $data['content'] = $content;
                else
                    show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

		$metatags = $this->metatags->getValue('cms',$idlang);
		$this->load->view('_shared/layouts/cms/header', $metatags);
		$this->load->view('_shared/layouts/cms/admin',$data);
	}
	
	function change_article_priority($id){
		$allow = $this->auth->hasAccess('articles');
		if($allow){
			$showorder = $_POST['priority'];
			$data=array( 'showorder' => $showorder);
			$this->admin_model->update_article($id, $data);
		}				
		redirect('/admin/articles', 'location');		
	}
	function add_article($idparent = null, $idlang = 3){
		$allow = $this->auth->hasAccess('articles');

		$data = $this->cms->getMenus('articles');
		if($allow){			
			if(isset($_POST['title']) && $_POST['title'] != ''){



				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->cms->generateFriendlyUrl($_POST['friendlyurl']);
				}else{
					if($_POST['title'] != ''){
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['title']);
					}else{
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['name']);
					}
				}
				
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}

                                $google_map     = isset($_POST['google_map']) ? true:false;
                                $contact_form   = isset($_POST['contact_form']) ? true:false;

				$files = array('header_image'=>'','image1'=>'','image2'=>'');

				if(isset($_FILES['header_image']) && $_FILES['header_image']['name']!=''){
					//uploadowanie pliku
					$config['upload_path']      = './files/img/articles/';
					$config['allowed_types']    = 'gif|jpg|png';
					$config['remove_spaces']    = TRUE;

					$this->load->library('upload', $config);
					$this->upload->do_upload('header_image');

					$file_data                  = $this->upload->data();
                                        $files['header_image']      = $file_data['file_name'];

					//zmiana praw pliku
					chmod('./files/img/articles/'. $files['header_image'] , 0777);
                                        rename('./files/img/articles/'. $files['header_image'] , './files/img/articles/'.date("Y_m_d-H_i_s")."_0.jpg");
                                        $files['header_image']      = '/files/img/articles/'.date("Y_m_d-H_i_s")."_0.jpg";
				}


				if(isset($_FILES['image1']) && $_FILES['image1']['name']!=''){
					//uploadowanie pliku
					$config['upload_path'] = './files/img/articles/';
					$config['allowed_types'] = 'gif|jpg|png';
					$config['remove_spaces'] = TRUE;		
					
					$this->load->library('upload', $config);
					$this->upload->do_upload('image1');

					$file_data          = $this->upload->data();
                                        $files['image1']    =   $file_data['file_name'];

					//zmiana praw pliku
					chmod('./files/img/articles/'. $files['image1'] , 0777);
                                        rename('./files/img/articles/'. $files['image1'] , './files/img/articles/'.date("Y_m_d-H_i_s")."_1.jpg");
                                        $files['image1']      = '/files/img/articles/'.date("Y_m_d-H_i_s")."_1.jpg";
				}

				if(isset($_FILES['image2']) && $_FILES['image2']['name']!=''){
					//uploadowanie pliku
					$config['upload_path'] = './files/img/articles/';
					$config['allowed_types'] = 'gif|jpg|png';
					$config['remove_spaces'] = TRUE;		
					
					$this->load->library('upload', $config);
					$this->upload->do_upload('image2');
					$file_data = $this->upload->data();
					$file_data          = $this->upload->data();
                                        $files['image2']    =   $file_data['file_name'];

					//zmiana praw pliku
					chmod('./files/img/articles/'.$files['image2'], 0777);
                                        rename('./files/img/articles/'. $files['image2'] , './files/img/articles/'.date("Y_m_d-H_i_s")."_2.jpg");
                                        $files['image2']      = '/files/img/articles/'.date("Y_m_d-H_i_s")."_2.jpg";
				}

				$data=array('idarticles' => '',
							'image1'        => $files['image1'],
                                                        'image2'        => $files['image2'],
							'date'          => date('c'),
							'idparent'      => $idparent,
                                                        'google_map'    => $google_map,
                                                        'contact_form'  => $contact_form,
							'active'        => $active
				);

				$this->admin_model->add_article($data);
				$data=array('idarticle_languages' => '',
							'idarticles' => $this->db->insert_id(),
							'idlanguages' => $_POST['idlanguage'],
							'name' => $_POST['name'],
							'header_image'  => $files['header_image'],
							'content' => $_POST['artcontent'],
							'title' => $_POST['title'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],
							'additional_data' => $_POST['additional_data'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->add_article_language($data);
				redirect('/admin/articles', 'location');	
			}else{
				//przygotowanie listy jezykow do boxa
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$bufor1[$i]=$lang['idlanguages'];
					$bufor2[$i]=$lang['shortname'];
					$i++;
				}
				$data['languages']=array_combine($bufor1,$bufor2);
				$data['meta'] = $this->metatags->getValue('article',$idlang);
				$data['idparent'] = $idparent;				
				$data['content'] = $this->load->view('admin/add_article', $data, true);
				
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}
	
	function delete_article_language($idarticle){
		if($this->auth->hasAccess('articles')){
			$idarticle_language = $_POST['idarticle_languages'];
			$this->admin_model->delete_article_language($idarticle_language);
			$data = $this->admin_model->get_article_languages_by_idarticles($idarticle);
			if(!isset($data[0])){
				$deleted_article = $this->admin_model->get_article_by_id($idarticle);
				$this->admin_model->delete_article($idarticle);	
				//kasacja fotek
				if(isset($deleted_article[0])){
                                                if(!empty($deleted_article[0]['image1']))
                                                {
                                                    @unlink('./files/img/articles/'.$deleted_article[0]['image1']);
                                                    @unlink('./files/img/articles/min/'.$deleted_article[0]['image1']);
                                                }
                                                if(!empty($deleted_article[0]['image2']))
                                                {
                                                    @unlink('./files/img/articles/'.$deleted_article[0]['image2']);
                                                    @unlink('./files/img/articles/min/'.$deleted_article[0]['image2']);
                                                }

				//zmiana id parenta u potomkow
				$update_data = array( 'idparent' => $deleted_article[0]['idparent'] );
				$this->admin_model->update_change_article_parent($idarticle,$update_data);
				}
			}
		}
		redirect('/admin/articles', 'location');	
	}
	
	function add_article_language($id_articles, $idlang = 3){
		$data = $this->cms->getMenus('articles');
		if($this->auth->hasAccess('articles')){
			if(isset($_POST['title']) && $_POST['title'] != ''){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->cms->generateFriendlyUrl($_POST['friendlyurl']);
				}else{
					if($_POST['title'] != ''){
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['title']);
					}else{
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['name']);
					}
				}
				
				$data=array('idarticle_languages' => '',
							'idarticles' => $id_articles,
							'idlanguages' => $_POST['idlanguage'],
							'name' => $_POST['name'],
							'content' => $_POST['artcontent'],
							'title' => $_POST['title'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],
							'additional_data' => $_POST['additional_data'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->add_article_language($data);
				redirect('/admin/articles', 'location');	
			}else{
				$data['id_articles'] = $id_articles;
				//przygotowanie listy jezykow do boxa
				$used_langs = $this->admin_model->get_article_languages_by_idarticles($id_articles);
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$flag = 1;
					foreach($used_langs as $used_lang){
						if($lang['idlanguages'] == $used_lang['idlanguages'])
						{
							$flag = 0;
							break;
						}
					}
					if($flag){
						$bufor1[$i]=$lang['idlanguages'];
						$bufor2[$i]=$lang['shortname'];
						$i++;
					}
				}	
				if($bufor1!=array() && $bufor2!=array()){			
					$data['languages']=array_combine($bufor1,$bufor2);		
					$data['meta'] = $this->metatags->getValue('article',$idlang);
					$data['content'] = $this->load->view('admin/add_article_language', $data, true);
				}else{
					$data['content'] = $this->localization['wszystkie_wersje_dostepne'];
				}
				
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}
	
	function edit_article_language($idlang = 3){
		$data2 = $this->cms->getMenus('articles');

            if(!$this->auth->hasAccess('articles'))
                show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));


			if(isset($_POST['name']) && $_POST['name'] != ''){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->cms->generateFriendlyUrl($_POST['friendlyurl']);
				}else{
					if($_POST['title'] != ''){
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['title']);
					}else{
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['name']);
					}
				}
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}

                                $google_map     = isset($_POST['google_map']) ? true:false;
                                $contact_form   = isset($_POST['contact_form']) ? true:false;

				$idarticle_languages = $_POST['idarticle_languages'];

                                //header_image
				if(isset($_FILES['header_image']['name']) && !empty($_FILES['header_image']['name']))
                                {
					//uploadowanie pliku
					$config['upload_path'] = './files/img/articles/';
					$config['allowed_types'] = 'jpg';
					$config['remove_spaces'] = TRUE;

					$this->load->library('upload', $config);


                                        if(!$this->upload->do_upload('header_image'))
                                        {
                                            $this->messages->add('Wystąpił błąd podczas wysyłania obrazka.', 'error');
                                            redirect('/admin/articles/'.$idlang, 'location', 301);
                                        }
                                        else
                                        {
                                            $photo = $this->admin_model->get_article_lang_by_id($_POST['idarticle_languages']);
                                            if(isset($photo[0]) && $photo[0]['header_image']!='' && file_exists('.'.$photo[0]['header_image']))
                                            {
                                                @unlink('.'.$photo[0]['header_image']);
                                            }
                                        }
                                        $file_data = $this->upload->data();

                                        chmod('./files/img/articles/'.$file_data['file_name'], 0777);
                                        rename('./files/img/articles/'.$file_data['file_name'], './files/img/articles/'.date("Y_m_d-H_i_s")."_0.jpg");

					$data = array('header_image'=> '/files/img/articles/'.date("Y_m_d-H_i_s")."_0.jpg");
					$this->admin_model->update_article_language($_POST['idarticle_languages'], $data);
				}


                                //IMAGE 1
				if(isset($_FILES['image1']['name']) && !empty($_FILES['image1']['name']))
                                {
					//uploadowanie pliku
					$config['upload_path']      = './files/img/articles/';
					$config['allowed_types']    = 'jpg';
					$config['remove_spaces']    = TRUE;

					$this->load->library('upload', $config);


                                        if ( ! $this->upload->do_upload('image1'))
                                        {
                                            $this->messages->add('Wystąpił błąd podczas wysyłania obrazka.', 'error');
                                            redirect('/admin/articles/'.$idlang, 'location', 301);
                                        }
                                        else
                                        {
                                            $photo = $this->admin_model->get_article_by_id($_POST['idarticles']);
                                            if(isset($photo[0]) && $photo[0]['image1']!='' && file_exists('.'.$photo[0]['image1'])){
                                                @unlink('.'.$photo[0]['image1']);
                                            }
                                        }
                                                            $file_data = $this->upload->data();

                                        chmod('./files/img/articles/'.$file_data['file_name'], 0777);
                                        rename('./files/img/articles/'.$file_data['file_name'], './files/img/articles/'.date("Y_m_d-H_i_s")."_1.jpg");

					$data = array('image1'=> '/files/img/articles/'.date("Y_m_d-H_i_s")."_1.jpg");
					$this->admin_model->update_article($_POST['idarticles'], $data);
				}

                                //IMAGE 2
				if(isset($_FILES['image2']['name']) && !empty($_FILES['image2']['name']))
                                {

					//uploadowanie pliku
					$config['upload_path']      = './files/img/articles/';
					$config['allowed_types']    = 'jpg';
					$config['remove_spaces']    = TRUE;

					$this->load->library('upload', $config);
					if(!$this->upload->do_upload('image2'))
                                        {
                                            $this->messages->add('Wystąpił błąd podczas wysyłania obrazka.', 'error');
                                            redirect('/admin/articles/'.$idlang, 'location', 301);
                                        }
                                        else
                                        {
                                            $photo = $this->admin_model->get_article_by_id($_POST['idarticles']);
                                            if(isset($photo[0]) && $photo[0]['image2']!='' && file_exists('.'.$photo[0]['image2'])){
                                                @unlink('.'.$photo[0]['image2']);
                                            }
                                        }
					$file_data = $this->upload->data();

                                        chmod('./files/img/articles/'.$file_data['file_name'], 0777);
                                        rename('./files/img/articles/'.$file_data['file_name'], './files/img/articles/'.date("Y_m_d-H_i_s")."_2.jpg");

					$data = array('image2'=> '/files/img/articles/'.date("Y_m_d-H_i_s")."_2.jpg");
					$this->admin_model->update_article($_POST['idarticles'], $data);
				}

				$data=array('active' => $active,'google_map'=>$google_map, 'contact_form'=>$contact_form);
				$this->admin_model->update_article($_POST['idarticles'], $data);

				$data=array('idlanguages' => $_POST['idlanguage'],
                                                        'idlists'       => empty($_POST['idlists']) ? null: $_POST['idlists'],
                                                        'idslideshow'   => empty($_POST['idslideshow']) ? null:$_POST['idslideshow'],
							'name'          => $_POST['name'],
							'content'       => $_POST['artcontent'],
							'title'         => $_POST['title'],
							'keywords'      => $_POST['keywords'],
							'shortdesc'     => $_POST['shortdesc'],
							'abstract'      => $_POST['abstract'],
							'subject'       => $_POST['subject'],
							'topic'         => $_POST['topic'],
							'copyrights'        => $_POST['copyrights'],
							'additional_data' => $_POST['additional_data'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->update_article_language($idarticle_languages, $data);

				redirect('/admin/articles', 'location');
			}else{
				$idarticle_languages = $_POST['idarticle_languages'];
				//przygotowanie danych
				$article = $this->admin_model->get_article_lang_by_id($idarticle_languages);
				if(isset($article[0])){
					$article = $article[0];


					$data = array(	'idarticle_languages' => $idarticle_languages,
									'idarticles' => $article['idarticles'],
                                                                        'idslideshow' => $article['idslideshow'],
                                                                        'idlists' => $article['idlists'],
                                                                        'name' => $article['name'],
                                                                        'header_image' => $article['header_image'],
                                                                        'image1' => $article['image1'],
                                                                        'image2' => $article['image2'],
									'content' => $article['content'],
									'title' => $article['title'],
									'keywords' => $article['keywords'],
									'shortdesc' => $article['shortdesc'],
									'abstract' => $article['abstract'],
									'subject' => $article['subject'],
									'topic' => $article['topic'],
									'copyrights' => $article['copyrights'],
									'friendlyurl' => $article['friendlyurl'],
									'additional_data' => $article['additional_data'],
                                                                        'google_map' => $article['google_map'],
                                                                        'contact_form' => $article['contact_form'],
									'active' => $article['active']
								);

					//przygotowanie listy jezykow do boxa
					$languages = $this->admin_model->get_languages();
					$bufor1=array($article['idlanguages']);
					$bufor2=array('---');
					$i = 1;
					foreach($languages as $lang){
						$bufor1[$i]=$lang['idlanguages'];
						$bufor2[$i]=$lang['shortname'];
						$i++;
					}
					$data['languages']=array_combine($bufor1,$bufor2);


                                        $lists          = $this->list_model->getAll();
                                        if(!empty($lists))
                                            $data['lists']  = $this->cms->arrayListToDictionary($lists,'id','name',true);
                                        else
                                            $data['lists'] = array(''=>'');

                                        $slideshows         = $this->slideshow_model->getAll();
                                        if(!empty($slideshows))
                                            $data['slideshows'] = $this->cms->arrayListToDictionary($slideshows,'id','name',true);
                                        else
                                            $data['lists'] = array(''=>'');


                                        $data['idarticle_languages']=$idarticle_languages;
                                        $data2['content']           = $this->load->view('admin/edit_article_language', $data, true);

					$metatags = $this->metatags->getValue('cms',$idlang);
					$this->load->view('_shared/layouts/cms/header', $metatags);
					$this->load->view('_shared/layouts/cms/admin',$data2);
				}else{
					redirect('/admin/articles', 'location');
				}
			}

	}

        
     function del_article_header_image($articleLanguageId)
    {
        $result = 0;
        $article = $this->admin_model->get_article_lang_by_id($articleLanguageId);
        if(!empty($article[0]))
        {
            $article = $article[0];
            if(!empty($article['header_image']) && file_exists('.'.$article['header_image']))
            {
                $data['header_image'] = "";
                if(unlink('.'.$article['header_image']))
                {
                    $this->admin_model->update_article_language($articleLanguageId, $data);
                    $result = 1;
                }
            }
        }
        echo $result;
    }
    //ajax function
    function del_article_image($articleId,$imageNr)
    {
        $imageNr = (int)$imageNr;
        if($imageNr != 1 && $imageNr != 2)
        {
            echo "błędna wartość parametru";
            return;
        }

        $article = $this->admin_model->get_article_by_id($articleId);
        if(!empty($article) && is_array($article))
        {
            $article  = $article[0];
            $file     = $article['image'.$imageNr];
            if(file_exists('.'.$file))
            {
                $data['image'.$imageNr] = "";
                if(unlink('.'.$file))
                {
                    $this->admin_model->update_article($articleId, $data);
                    echo 1;
                    return;
                }
            }
            else
            {
                echo "file not exist ".$file;
                return;
            }
        }
        echo "Nie pobrano artykułu o wskazanym id";
    }
//menu
	function menus($idlang = 3){
            if(!$this->auth->hasAccess('slideshow'))
                show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

            $list['menus']      = $this->admin_model->get_menus();
            $list['menu_items'] = $this->admin_model->get_menu_items();

            $data           = $this->cms->getMenus('menus');
            

            //przygotowanie listy jezykow do boxa
            $languages = $this->admin_model->get_languages();
            $i = 0;
            foreach($languages as $lang){
                    $bufor1[$i]=$lang['idlanguages'];
                    $bufor2[$i]=$lang['fullname'];
                    $i++;
            }
            $list['languages'] = array_combine($bufor1,$bufor2);

            $content = $this->load->view('admin/menus', $list, true);


                $data['content'] = $content;

            $metatags = $this->metatags->getValue('cms',$idlang);
            $this->load->view('_shared/layouts/cms/header', $metatags);
            $this->load->view('_shared/layouts/cms/admin',$data);
	}
	
	function add_menu($idlang = 3){
		$data = $this->cms->getMenus('menus');
		if($this->auth->hasAccess('menus')){
			if(isset($_POST['title']) && $_POST['title'] != ''){
						
				$data=array('idmenus' => '',
							'name' => $_POST['title']
				);
				$this->admin_model->add_menu($data);
				redirect('/admin/menus', 'location');
			}else{			
				$data['content'] = $this->load->view('admin/add_menu', '', true);
				
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}

	function delete_menu($id){
		if($this->auth->hasAccess('menus')){
			$this->admin_model->delete_menu($id);
		}				
		redirect('/admin/menus', 'location');		
	}

	function change_menu_item_priority($id){
		if($this->auth->hasAccess('menus')){
			$data=array( 'showorder' => $_POST['priority']);
			$this->admin_model->update_menu_items($id, $data);
		}		
		redirect('/admin/menus', 'location');		
	}
	
	function add_menu_item($idmenus, $idparent=null, $idlang = 3){
		$data = $this->cms->getMenus('menus');
		if($this->auth->hasAccess('menus')){
			if(isset($_POST['title']) && $_POST['title'] != '' && isset($_POST['idlanguage']) && $_POST['idlanguage'] != '' && isset($_POST['idmenu_item_types']) && $_POST['idmenu_item_types'] != ''){
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
				
				if($_POST['friendlyurl'] != ''){
						//$friendlyurl = $this->cms->generateFriendlyUrl($_POST['friendlyurl']);
                        $pos = strpos($_POST['friendlyurl'],'http');
                        if($pos === false)
                            $friendlyurl = $this->cms->generateFriendlyUrl($_POST['friendlyurl']);
                        else
                            $friendlyurl = $_POST['friendlyurl'];
					}else{
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['title']);
					}
					
				$data=array('idmenu_items' => '',
							'idmenus' => $idmenus,
							'idmenu_item_types' => $_POST['idmenu_item_types'],
							'idelement' => empty($_POST['idelement']) ? null:$_POST['idelement'],
							'idparent' => $idparent,
							'active' => $active
				);
				$this->admin_model->add_menu_item($data);
				
				$mi_lang=array('idmenu_item_languages' => '',
								'idmenu_items' => $this->db->insert_id(),
								'idlanguages' => $_POST['idlanguage'],
								'friendlyurl' => $friendlyurl,
								'elementname' => $_POST['title']
				);
				$this->admin_model->add_menu_item_language($mi_lang);
				
				redirect('/admin/menus', 'location');	
			}else{		
				$data['idmenus'] = $idmenus;
				$data['idparent'] = $idparent;
				
			//przygotowanie listy jezykow do boxa
				$languages = $this->admin_model->get_languages();
				$bufor1[0]='';
				$bufor2[0]='';
				$i = 1;
				foreach($languages as $lang){
					$bufor1[$i]=$lang['idlanguages'];
					$bufor2[$i]=$lang['shortname'];
					$i++;
				}
				$data['languages']=array_combine($bufor1,$bufor2);
			//przygotowanie listy typow do boxa
				$mits = $this->admin_model->get_menu_item_types();
				$bufor1[0]='';
				$bufor2[0]='';
				$i = 1;
				foreach($mits as $mit){
					$bufor1[$i]=$mit['idmenu_item_types'];
					$bufor2[$i]=$mit['type'];
					$i++;
				}
				$data['menu_item_types']=array_combine($bufor1,$bufor2);
				
				$data['content'] = $this->load->view('admin/add_menu_item', $data, true);
				
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}
	
	function delete_menu_item_language(){
		if($this->auth->hasAccess('menus')){
			$menu_item_language = $this->admin_model->get_menu_item_by_id($_POST['idmenu_item_languages']);
			$this->admin_model->delete_menu_item_language($_POST['idmenu_item_languages']);
			$data = $this->admin_model->get_menu_item_languages($menu_item_language[0]['idmenu_items']);
			if(!isset($data[0])){
				$deleted_menu_items = $this->admin_model->get_menu_item_to_delete($menu_item_language[0]['idmenu_items']);
				$update_data = array( 'idparent' => $deleted_menu_items[0]['idparent'] );
				$children = $this->admin_model->get_menu_item_children($deleted_menu_items[0]['idmenu_items']);
				//zmiana id parenta u potomkow
				$this->admin_model->delete_menu_item($menu_item_language[0]['idmenu_items']);
				foreach($children as $child){
					$this->admin_model->update_menu_items($child['idmenu_items'],$update_data);
				}
				$this->admin_model->delete_menu_item($menu_item_language[0]['idmenu_items']);	
			}
		}
		redirect('/admin/menus', 'location');		
	}
	
	function delete_menu_item($idmenu_item){
		if($this->auth->hasAccess('menus')){
			$this->admin_model->delete_menu_item_language_by_idmenu_items($idmenu_item);
			$data = $this->admin_model->get_menu_item_languages($idmenu_item);
			if(!isset($data[0])){
				$deleted_menu_items = $this->admin_model->get_menu_item_to_delete($idmenu_item);
				$update_data = array( 'idparent' => $deleted_menu_items[0]['idparent'] );
				$children = $this->admin_model->get_menu_item_children($deleted_menu_items[0]['idmenu_items']);
				//zmiana id parenta u potomkow
				$this->admin_model->delete_menu_item($idmenu_item);
				foreach($children as $child){
					$this->admin_model->update_menu_items($child['idmenu_items'],$update_data);
				}
				$this->admin_model->delete_menu_item($idmenu_item);	
			}
		}
		redirect('/admin/menus', 'location');		
	}

	function edit_menu_item_language($idlang = 3){
		$data = $this->cms->getMenus('menus');
		if($this->auth->hasAccess('menus')){
			if(isset($_POST['title']) && $_POST['title'] != ''){
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}

				if($_POST['friendlyurl'] != ''){
                    $pos = strpos($_POST['friendlyurl'],'http');
                    if($pos === false)
                        $friendlyurl = $this->cms->generateFriendlyUrl($_POST['friendlyurl']);
                    else
                        $friendlyurl = $_POST['friendlyurl'];
				}else{
					$friendlyurl = $this->cms->generateFriendlyUrl($_POST['title']);
				}
				
				
				$idmenu_items = $_POST['idmenu_items'];
				$data = array( 'active' => $active );
				$this->admin_model->update_menu_items($idmenu_items, $data);
				
				$mi_lang=array(	'friendlyurl' => $friendlyurl,
								'elementname' => $_POST['title']
				);
				$this->admin_model->update_menu_item_languages($_POST['idmenu_item_languages'], $mi_lang);
				
				redirect('/admin/menus', 'location');	
			}else{		
				$menu_item_language = $this->admin_model->get_menu_item_by_id($_POST['idmenu_item_languages']);
				$data['idmenu_item_languages'] = $_POST['idmenu_item_languages'];
				$data['idmenu_items'] = $menu_item_language[0]['idmenu_items'];
				$data['active'] = $menu_item_language[0]['active'];
				$data['idlanguages'] = $menu_item_language[0]['idlanguages'];
				$data['friendlyurl'] = $menu_item_language[0]['friendlyurl'];
				$data['title'] = $menu_item_language[0]['elementname'];
				
				$data['content'] = $this->load->view('admin/edit_menu_item', $data, true);
				
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}

	function add_menu_item_language($idmenu_item, $idlang = 3){
		$data = $this->cms->getMenus('menus');
		if($this->auth->hasAccess('menus')){
			if(isset($_POST['title']) && $_POST['title'] != ''){
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
				
				$mi_lang=array('idmenu_item_languages' => '',
								'idmenu_items' => $idmenu_item,
								'idlanguages' => $_POST['idlanguage'],
								'friendlyurl' => $_POST['friendlyurl'],
								'elementname' => $_POST['title']
				);
				$this->admin_model->add_menu_item_language($mi_lang);
				
				redirect('/admin/menus', 'location');	
			}else{		
				$data['idmenu_item'] = $idmenu_item;
				
				if(isset($_POST['idlanguage']) && $_POST['idlanguage']!=null){	
					$data['languages'] = $_POST['idlanguage'];		
					$data['content'] = $this->load->view('admin/add_menu_item_language', $data, true);
				}else{
					$data['content'] = $this->localization['wszystkie_wersje_dostepne'];
				}
				
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}

//notes
	function notes($idlang = 3){
                if(!$this->auth->hasAccess('slideshow'))
                  show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

		$data = $this->cms->getMenus('notes');
		$list['notes'] = $this->admin_model->get_notes();
		
		$data['content'] = $this->load->view('admin/notes', $list, true);
		
		$metatags = $this->metatags->getValue('cms',$idlang);
		$this->load->view('_shared/layouts/cms/header', $metatags);
		$this->load->view('_shared/layouts/cms/admin',$data);
	}

	function add_note($idlang = 3){
		if($this->auth->hasAccess('notes')){
			if(isset($_POST['title']) && $_POST['title'] != ''){
				$data=array('idnotes' => '',				
							'idusers' => $this->session->userdata('idusers'),
							'title' => $_POST['title'],
							'content' => $_POST['artcontent'],
							'date' => date('c')
				);
				$this->admin_model->add_note($data);
				redirect('/admin/notes', 'location');	
			}else{				
				$data = $this->cms->getMenus('notes');
				$data['content'] = $this->load->view('admin/add_note', '', true);

				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}

	function delete_note($idnote){
		$allow = $this->auth->hasAccess('notes');
		if($this->auth->hasAccess('notes')){
			$this->admin_model->delete_note($idnote);
		}
		redirect('/admin/notes', 'location');		
	}

//json
	function get_json_data_for_menu($idmenu_item_types, $idlang){
		$bufor1=array();
		$bufor2=array();
                //first empty row
                $bufor1[]='';
                $bufor2[]='';

		$i = 1;
		
		switch ($idmenu_item_types) {
		    case 4:
		        $languages = $this->admin_model->get_article_languages();
				foreach($languages as $lang){
					if($lang['idlanguages']==$idlang){
						$bufor1[$i]=$lang['idarticles'];
						$bufor2[$i]=$lang['name'];
						$i++;
					}
				}

		        break;
		    case 5:
		        $languages = $this->admin_model->get_news_languages();
				foreach($languages as $lang){
					if($lang['idlanguages']==$idlang){
						$bufor1[$i]=$lang['idnewses'];
						$bufor2[$i]=$lang['name'];
						$i++;
					}
				}
		        break;
		    case 6:
		       $languages = $this->admin_model->get_galleries_languages();
                
			   	foreach($languages as $lang){
					if($lang['idlanguages']==$idlang){
						$bufor1[$i]=$lang['idgalleries'];
						$bufor2[$i]=$lang['name'];
						$i++;
					}
				}
		        break;
			case 8:
		        $languages = $this->admin_model->get_product_categories();
				foreach($languages as $lang){
					$bufor1[$i]=$lang['idproduct_categories'];
					$bufor2[$i]=$lang['type'];
					$i++;
				}
		        break;
			case 9:
		        $languages = $this->admin_model->get_product_languages();
				foreach($languages as $lang){
					if($lang['idlanguages']==$idlang){
						$bufor1[$i]=$lang['idproducts'];
						$bufor2[$i]=$lang['name'];
						$i++;
					}
				}
		        break;
			default:
			  $bufor1[$i] = 1;
			  $bufor2[$i] = '---';
			  break; 
		};

		//wczesniej napisany widok-nie zmieniam, bo nie ma sensu dodawac nowy
		if($bufor1 != array() && $bufor2 != array()){
			$data['metatags'] = json_encode(array_combine($bufor1,$bufor2));
		}else{
			$data['metatags'] = json_encode(array());
		}
		$data['metatags'] = json_encode(array_combine($bufor1,$bufor2));
		$this->load->view('admin/metatags_json', $data);
	}
	function get_json_meta_types($idlangs){
		$results = $this->admin_model->get_metatag_types_languages_by_lang($idlangs);
		$result ='';
		if(isset($results[0])){
			foreach($results as $group){
				$result .= '<option value="'.$group['idmetatags'].'">'.$group['template'].'</option>';
			}
		}
		$result = array('content'=>$result);
		$data['metatags'] = json_encode($result);
		$this->load->view('admin/metatags_json', $data);
	}
	//pobiera metatagi danego typu w formacie jsona(potrzebne przy automatycznym ladowaniuu standardowych metatagow)
	function get_json_meta($idmetatags){
		$result = $this->admin_model->get_metatag_by_id($idmetatags);
		if(isset($result[0])){
			$result = $result[0];
		}else{
			$result = '';
		}
		$data['metatags'] = json_encode($result);
		$this->load->view('admin/elements/metatags_json', $data);
	}
        //panel zarzadzania CMSem - prawa
	function show_rights($idlang = 3){
		$data = $this->cms->getMenus();
		$list['rights'] = $this->admin_model->get_rights();
		$list['groups'] = $this->admin_model->get_user_groups();		
		$list['user_group_elements'] = $this->admin_model->get_user_group_elements();
		
		$content = $this->load->view('admin/rights', $list, true);
		//$data['content'] = $this->check_login('rights', $content);

                if($this->auth->hasAccess('rights'))
                    $data['content'] = $content;
                else
                    show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

		
		$metatags = $this->metatags->getValue('cms',$idlang);
		$this->load->view('_shared/layouts/cms/header', $metatags);
		$this->load->view('_shared/layouts/cms/admin',$data);
	}
	
	function change_user_group_elements($idelement, $idgroup){
		if($this->auth->hasAccess('rights')){
			$exist = $this->admin_model->get_user_group_element($idelement, $idgroup);
			if(isset($exist[0])){
				if($exist[0]['active']){
					//zmiana statusu na false
					$data = array( 'active'=> false);
					$this->admin_model->update_user_group_elements($exist[0]['iduser_group_elements'], $data);
				}else{
					//zmiana statusu na true
					$data = array( 'active'=> true);
					$this->admin_model->update_user_group_elements($exist[0]['iduser_group_elements'], $data);
				}
			}else{
				//utworzenie powiazania grupy z elementem
				$data = array( 'idelements' => $idelement,
								'iduser_groups' => $idgroup,
								'active' => true
							);
				$this->admin_model->add_user_group_elements($data);
			}
		}
		redirect('/admin/rights', 'location');
	}
		
	function change_element_priority($id){
		if($this->auth->hasAccess('rights')){
			$data=array( 'showorder' => $_POST['priority']);
			$this->admin_model->update_elements($id, $data);
		}		
		redirect('/admin/rights', 'location');		
	}

        //jezyki
	function languages($idlang = 3){
                if(!$this->auth->hasAccess('languages'))
                    show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

		$data = $this->cms->getMenus('languages');
		$list['languages'] = $this->admin_model->get_all_languages();
		
		$data['content'] = $this->load->view('admin/languages', $list, true);
		
		$metatags = $this->metatags->getValue('cms',$idlang);
		$this->load->view('_shared/layouts/cms/header', $metatags);
		$this->load->view('_shared/layouts/cms/admin',$data);
	}
	
	function change_language_priority($id){
		if($this->auth->hasAccess('languages')){
			$data=array( 'showorder' => $_POST['priority']);
			$this->admin_model->update_languages($id, $data);
		}		
		redirect('/admin/languages', 'location');		
	}
	
	function add_language($idlang = 3){
		if($this->auth->hasAccess('languages')){
			if(isset($_POST['fullname']) && $_POST['fullname'] != ''){
				$data=array('idlanguages' => '',				
							'fullname' => $_POST['fullname'],
							'shortname' => $_POST['shortname']
				);
				$this->admin_model->add_language($data);
				redirect('/admin/languages', 'location');	
			}else{			
				$data = $this->cms->getMenus('languages');
				$data['content'] = $this->load->view('admin/add_language', '', true);

				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}
	
	function edit_language($idlang_to_edit, $idlang = 3){
		if($this->auth->hasAccess('languages')){
			if(isset($_POST['fullname']) && $_POST['fullname'] != ''){
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
				
				$data=array('fullname' => $_POST['fullname'],
							'active' => $active,
							'shortname' => $_POST['shortname']
				);
				$this->admin_model->update_languages($idlang_to_edit, $data);
				redirect('/admin/languages', 'location');	
			}else{			
				$data = $this->cms->getMenus('languages');
				$languages = $this->admin_model->get_language_by_id($idlang_to_edit);
				if(isset($languages[0])){
					$data['content'] = $this->load->view('admin/edit_language', $languages[0], true);
				}else{
					$data['content'] = 'Nie ma takiego jezyka.';
				}
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}
        function sitemap_xml()
        {
            $newline = chr(10);
            $tab = chr(9);
            $twotabs = $tab.$tab;


            $data = '<?xml version="1.0" encoding="UTF-8"?>'.$newline;
            $data .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">'.$newline;
                    $data .= $tab.'<url>'.$newline;
                            $data .= $twotabs.'<loc>'.base_url().'</loc>'.$newline;
                            $data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
                            $data .= $twotabs.'<priority>1.0</priority>'.$newline;
                    $data .= $tab.'</url>'.$newline;

                    $languages = $this->admin_model->get_languages();
                    foreach($languages as $language)
                    {
                            $site    = $this->config->item($language['shortname']);
                            $short   = strtolower($language['shortname']);
                            $lang_id =  $language['idlanguages'];

                                        //artykuly
					$articles = $this->admin_model->get_article_languages();
					foreach($articles as $article){
                                            if($article['shortname'] == $language['shortname']){
                                                    $data .= $tab.'<url>'.$newline;
                                                            $data .= $twotabs.'<loc>'.base_url().$article['friendlyurl'].'-4-'.$lang_id.'-'.$article['idarticles'].'.html</loc>'.$newline;
                                                            $data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
                                                            $data .= $twotabs.'<priority>0.8</priority>'.$newline;
                                                    $data .= $tab.'</url>'.$newline;
						}
                                        }

                                        //przejscie po galleriach
					$galleries = $this->admin_model->get_galleries();
					foreach($galleries as $gallery){
						if($gallery['shortname'] == $language['shortname']){
							$data .= $tab.'<url>'.$newline;
								$data .= $twotabs.'<loc>'.base_url().$gallery['friendlyurl'].'-6-'.$lang_id.'-'.$gallery['idgalleries'].'.html</loc>'.$newline;
								$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
								$data .= $twotabs.'<priority>0.8</priority>'.$newline;
							$data .= $tab.'</url>'.$newline;
						}
                                        }

                                        //przejsce po newsach

					$newses = $this->admin_model->get_news_languages();
					foreach($newses as $news){
						if($news['shortname'] == $language['shortname']){
							$data .= $tab.'<url>'.$newline;
								$data .= $twotabs.'<loc>'.base_url().$news['friendlyurl'].'-5-'.$lang_id.'-'.$news['idnewses'].'.html</loc>'.$newline;
								$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
								$data .= $twotabs.'<priority>0.8</priority>'.$newline;
							$data .= $tab.'</url>'.$newline;
						}
                                        }
					
                    }
                    
            $data .= '</urlset>';
            echo $data;
        }

//generowanie sitemap.xml
        
	function generate_sitemap(){
		if($this->auth->hasAccess('sitemap')){
			$this->load->helper('file');			
			
			$newline = chr(10);
			$tab = chr(9);
			$twotabs = $tab.$tab;
			
			
			$data = '<?xml version="1.0" encoding="UTF-8"?>'.$newline;
			$data .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">'.$newline;
				$data .= $tab.'<url>'.$newline;
					$data .= $twotabs.'<loc>'.base_url().'</loc>'.$newline;
					$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
					$data .= $twotabs.'<priority>1.0</priority>'.$newline;
				$data .= $tab.'</url>'.$newline;
			//tu beda wszystkie foreachy
			//przejscie po jezykach
				$languages = $this->admin_model->get_languages();
				foreach($languages as $language){	
					$site = $this->config->item($language['shortname']);
					$short = strtolower($language['shortname']);
					/*
				//przejscie po artykulach
					$data .= $tab.'<url>'.$newline;
						$data .= $twotabs.'<loc>'.base_url().$short.'/'.$site['linki_do_sitemapy']['artykuly'].'.html</loc>'.$newline;
						$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
						$data .= $twotabs.'<priority>0.9</priority>'.$newline;
					$data .= $tab.'</url>'.$newline;
					*/
					
					$articles = $this->admin_model->get_article_languages();
					foreach($articles as $article){	
						if($article['shortname'] == $language['shortname'] && $article['idarticles'] != 88){
							$flag = true;
							foreach($articles as $subarticle){	
								if($article['idarticles'] == $subarticle['idparent']){
									$flag = false;
								}
							}
							if($flag){
								$data .= $tab.'<url>'.$newline;
									$data .= $twotabs.'<loc>'.base_url().$short.'/'.$site['linki_do_sitemapy']['artykul'].'/'.$article['friendlyurl'].'-'.$article['idarticles'].'.html</loc>'.$newline;
									$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
									$data .= $twotabs.'<priority>0.8</priority>'.$newline;
								$data .= $tab.'</url>'.$newline;
							}
						}
					}

				//przejscie po newsach
				/*
					$data .= $tab.'<url>'.$newline;
						$data .= $twotabs.'<loc>'.base_url().$short.'/'.$site['linki_do_sitemapy']['newsy'].'.html</loc>'.$newline;
						$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
						$data .= $twotabs.'<priority>0.9</priority>'.$newline;
					$data .= $tab.'</url>'.$newline;
					
					$newses = $this->admin_model->get_news_languages();
					foreach($newses as $news){	
						if($news['shortname'] == $language['shortname']){
							$data .= $tab.'<url>'.$newline;
								$data .= $twotabs.'<loc>'.base_url().$short.'/'.$site['linki_do_sitemapy']['news'].'/'.$news['friendlyurl'].'-'.$news['idnews_languages'].'.html</loc>'.$newline;
								$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
								$data .= $twotabs.'<priority>0.8</priority>'.$newline;
							$data .= $tab.'</url>'.$newline;
						}
					}
					*/
				//przejscie po galleriach
				/*
					$data .= $tab.'<url>'.$newline;
						$data .= $twotabs.'<loc>'.base_url().$short.'/'.$site['linki_do_sitemapy']['galerie'].'.html</loc>'.$newline;
						$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
						$data .= $twotabs.'<priority>0.9</priority>'.$newline;
					$data .= $tab.'</url>'.$newline;
					$galleries = $this->admin_model->get_galleries();
					foreach($galleries as $gallery){	
						if($gallery['shortname'] == $language['shortname']){
							$data .= $tab.'<url>'.$newline;
								$data .= $twotabs.'<loc>'.base_url().$short.'/'.$site['linki_do_sitemapy']['galeria'].'/'.$gallery['friendlyurl'].'-'.$gallery['idgalleries_languages'].'.html</loc>'.$newline;
								$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
								$data .= $twotabs.'<priority>0.8</priority>'.$newline;
							$data .= $tab.'</url>'.$newline;
						}
					}
				
				//przejscie po obrazkach
					$images = $this->admin_model->get_img_lang_versions();
					foreach($images as $image){	
						if($image['shortname'] == $language['shortname']){
							$data .= $tab.'<url>'.$newline;
								$data .= $twotabs.'<loc>'.base_url().$short.'/'.$site['linki_do_sitemapy']['galeria'].'/'.$image['friendlyurl'].'-'.$image['idimages_languages'].'.html</loc>'.$newline;
								$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
								$data .= $twotabs.'<priority>0.7</priority>'.$newline;
							$data .= $tab.'</url>'.$newline;
						}
					}
					*/	
					/*
					$products = $this->admin_model->get_menu_by_id( 15, $language['idlanguages']);
					foreach($products as $parent){
						if($parent['idparent']==null){
							switch($parent['type']){
								case 'product_category':
									$data .= $tab.'<url>'.$newline;
										$data .= $twotabs.'<loc>'.base_url().$short.'/'.$parent['friendlyurl'].'.html</loc>'.$newline;
										$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
										$data .= $twotabs.'<priority>0.8</priority>'.$newline;
									$data .= $tab.'</url>'.$newline;
									break;
								case 'product':
									$data .= $tab.'<url>'.$newline;
										$data .= $twotabs.'<loc>'.base_url().$short.'/'.$site['linki_do_sitemapy']['produkt'].'/'.$parent['friendlyurl'].'-'.$parent['idelement'].'.html</loc>'.$newline;
										$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
										$data .= $twotabs.'<priority>0.8</priority>'.$newline;
									$data .= $tab.'</url>'.$newline;
									break;
							}
							foreach($products as $product){	
								if($product['idparent']==$parent['idmenu_items']){
									switch($product['type']){
										case 'product_category':
											$data .= $tab.'<url>'.$newline;
												$data .= $twotabs.'<loc>'.base_url().$short.'/'.$product['friendlyurl'].'.html</loc>'.$newline;
												$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
												$data .= $twotabs.'<priority>0.8</priority>'.$newline;
											$data .= $tab.'</url>'.$newline;
											break;
										case 'product':
											$data .= $tab.'<url>'.$newline;
												$data .= $twotabs.'<loc>'.base_url().$short.'/'.$parent['friendlyurl'].'/'.$product['friendlyurl'].'-'.$product['idelement'].'.html</loc>'.$newline;
												$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
												$data .= $twotabs.'<priority>0.8</priority>'.$newline;
											$data .= $tab.'</url>'.$newline;
											break;
									}
								}
							}
						}
					}
					*/	
				}
			$data .= '</urlset>';	
			
		//zapisanie do pliku i potwierdzenie wykonania mapy strony
			$wyswietl = $this->cms->getMenus();
			if ( ! write_file('./files/sitemap.xml', $data, 'w'))
			{
				$wyswietl['content'] = 'Nie udało się zapisanie nowej mapy strony.';
			}
			else
			{
				if (!copy('./files/sitemap.xml','./sitemap.xml')) {
				    echo 'Kopiowanie mapy strony zakońzyło się niepowodzeniem.';
				}
				$wyswietl['content'] = 'Pomyślnie wygenerowano mapę strony.';
			}
		//wyswietlenie potwierdzenia
			$metatags = $this->metatags->getValue('cms','3');
			$this->load->view('_shared/layouts/cms/header', $metatags);
			$this->load->view('_shared/layouts/cms/admin',$wyswietl);
		}					
	}
//backup bazy
	function backup_database(){
		if($this->auth->hasAccess('backup_database')){
			$this->load->dbutil();
			$this->load->helper('file');	
			$filname = date('YndHis').'.zip';
			$prefs = array('tables' => array(	'languages',
												'user_groups',
												'elements',
												'user_group_elements',
												'users',
												'notes',
												'metatag_types',
												'metatags',
												'newses',
												'news_languages',
												'articles',
												'article_languages',
												'galleries',
												'galleries_languages',
												'images',
												'images_languages',
												'menu_item_types',
												'menus',
												'menu_items',
												'mit_languages',
												'menu_item_languages',												
												'products',
												'subproducts',
												'products_languages',
												'product_categories',
												'product_product_categories',
												'product_categories_languages'
											),
			                'format'      => 'zip',
			                'filename'    => $filname
			              );
			$backup =& $this->dbutil->backup($prefs); 
			
			//zapisanie do pliku i potwierdzenie wykonania mapy strony
			$wyswietl = $this->cms->getMenus();
			if ( ! write_file('./files/dbbackups/'.$filname, $backup, 'w'))
			{
				$wyswietl['content'] = 'Utworzenie kopii bazy danych nie powiodło się.';
			}
			else
			{
				$wyswietl['content'] = 'Pomyślnie utworzono kopię bazy danych.';
			}
		//wyswietlenie potwierdzenia
			$metatags = $this->metatags->getValue('cms','3');
			$this->load->view('_shared/layouts/cms/header', $metatags);
			$this->load->view('_shared/layouts/cms/admin',$wyswietl);
		}					
	}

//produkty
	function products($idlang = 3)
        {
            if(!$this->auth->hasAccess('products'))
                show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

		$list['language'] = $this->set_language($idlang);
		$list['products'] = $this->admin_model->get_products();
		$list['product_categories'] = $this->admin_model->get_product_categories();
		$list['product_languages'] = $this->admin_model->get_product_languages();
		$list['categories_languages'] = $this->admin_model->get_product_categories_languages();
		$list['children'] = $this->admin_model->get_product_children();
		$list['site'] = $this->localization;
		//przygotowanie listy gallerii
		$galleries = $this->admin_model->get_galleries();
		$galleries_languages = $this->admin_model->get_galleries_languages();
		$list['galleries'] = array();
		foreach($galleries as $gallery){
			foreach($galleries_languages as $galleries_language){
				if($gallery['idgalleries'] == $galleries_language['idgalleries']){
					$list['galleries'][$gallery['idgalleries']] = $galleries_language['title'];
					break;
				}
			}
		}
		//przygotowanie listy podproduktów
		$list['subproducts'] = $this->admin_model->get_products_by_cat_name('Elementy');
		//przygotowanie listy jezykow do boxa
		$languages = $this->admin_model->get_languages();
		$i = 0;
		foreach($languages as $lang){
			$bufor1[$i]=$lang['idlanguages'];
			$bufor2[$i]=$lang['fullname'];
			$i++;
		}
		$list['languages'] = array_combine($bufor1,$bufor2);
		$data = $this->cms->getMenus('products');

		$data['content'] = $this->load->view('admin/products', $list, true);
		
		$metatags = $this->metatags->getValue('cms',$idlang);
		$this->load->view('_shared/layouts/cms/header', $metatags);
		$this->load->view('_shared/layouts/cms/admin',$data);
	}
	
	function change_product_price($id){
		if($this->auth->hasAccess('products')){
			$data=array( 'price' => $_POST['priority']);
			$this->admin_model->update_product($id, $data);
		}				
		redirect('/admin/products', 'location');		
	}
	
	function change_complet_price($idparent, $idchild){
		if($this->auth->hasAccess('products')){
			$data=array( 'complet_price' => $_POST['priority']);
			$this->admin_model->update_subproduct($idparent, $idchild, $data);
		}				
		redirect('/admin/products', 'location');		
	}
	
	function add_product($idlang = 3){
		$data = $this->cms->getMenus('products');
		if($this->auth->hasAccess('products')){
			if(isset($_POST['title']) && $_POST['title'] != ''){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->cms->generateFriendlyUrl($_POST['friendlyurl']);
				}else{
					if($_POST['title'] != ''){
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['title']);
					}else{
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['name']);
					}
				}
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
				$file_data = array('file_name' => ''); 	
				if(isset($_FILES['file']) && $_FILES['file']['name']!=''){
					//uploadowanie pliku
					$config['upload_path'] = './files/img/products/';
					$config['allowed_types'] = 'gif|jpg|png';
					$config['remove_spaces'] = TRUE;		
					
					$this->load->library('upload', $config);
					$this->upload->do_upload('file');
					$file_data = $this->upload->data();
					//zmiana praw pliku
					chmod('./files/img/products/'.$file_data['file_name'], 0777);
					//tworzenie miniaturki
					$img_config['image_library'] = 'gd2';
					$img_config['source_image'] = './files/img/products/'.$file_data['file_name'];
					$img_config['new_image'] = './files/img/products/min/';
					$img_config['maintain_ratio'] = TRUE;
					$img_config['width'] = $this->product['width'];
					$img_config['height'] = $this->product['height'];
					$this->load->library('image_lib', $img_config);
					$this->image_lib->resize();
					if ( ! $this->image_lib->resize()){
					    echo $this->image_lib->display_errors();
					}	
				}				
				$data=array('idproducts' => '',
							'name' => $_POST['title'],
							'photo' => $file_data['file_name'],
							'price' => $_POST['price'],
							'active' => $active
				);
				$this->admin_model->add_product($data);
				$idadded_product = $this->db->insert_id();
				$data=array('idproducts_languages' => '',
							'idproducts' => $idadded_product,
							'idlanguages' => $_POST['idlanguage'],
							'name' => $_POST['name'],
							'content' => $_POST['artcontent'],
							'title' => $_POST['title'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],							
							'additional_data' => $_POST['additional_data'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->add_product_language($data);
				
				$subproducts = $this->admin_model->get_products_by_cat_name('Elementy');
				foreach($subproducts as $subproduct){
					if(isset($_POST[$subproduct['name']])){
						$data = array(	'idsubproducts' => '',
										'idparent' => $idadded_product,
										'idchild' => $subproduct['idproducts']
									);
						$this->admin_model->add_subproduct($data);
					}
				}
				
				$data = array(	'idproduct_product_categories' => '',
								'idproduct_categories' => $_POST['idcategory'],
								'idproducts' => $idadded_product
							);
				$this->admin_model->add_product_product_category($data);
						
				redirect('/admin/products', 'location');	
			}else{
				//przygotowanie listy jezykow do boxa
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$bufor1[$i]=$lang['idlanguages'];
					$bufor2[$i]=$lang['shortname'];
					$i++;
				}
				
				$data['languages']=array_combine($bufor1,$bufor2);
				
				//przygotowanie listy kategorii
				$categories = $this->admin_model->get_product_categories();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($categories as $category){
					$bufor1[$i]=$category['idproduct_categories'];
					$bufor2[$i]=$category['type'];
					$i++;
				}
				$data['categories']=array_combine($bufor1,$bufor2);
				
				//przygotowanie listy podproduktów
				$data['subproducts'] = $this->admin_model->get_products_by_cat_name('Elementy');
				
				//$data['meta'] = $this->metatags->getValue('article',$idlang);
				$data['content'] = $this->load->view('admin/add_product', $data, true);
				
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}
	
	function delete_product_language($idproduct){
		if($this->auth->hasAccess('products')){
			$idproduct_languages = $_POST['idproduct_languages'];
			$this->admin_model->delete_product_language($idproduct_languages);
			$data = $this->admin_model->get_product_languages_by_idproducts($idproduct);
			if(!isset($data[0])){
				$deleted_product = $this->admin_model->get_product_by_id($idproduct);
				$this->admin_model->delete_subproduct_by_idparent($idproduct);	
				$this->admin_model->delete_subproduct_by_idchild($idproduct);	
				$this->admin_model->delete_product_product_category_by_idproduct($idproduct);	
				$this->admin_model->delete_product($idproduct);	
				//kasacja fotek
				if(isset($deleted_product[0])){
					if($deleted_product[0]['photo']!=''){
						unlink('./files/img/products/'.$deleted_product[0]['photo']);
						unlink('./files/img/products/min/'.$deleted_product[0]['photo']);
					}
				}
			}
		}
		redirect('/admin/products', 'location');	
	}
	
	function add_product_language($idproduct, $idlang = 3){
		$data = $this->cms->getMenus('products');
		if($this->auth->hasAccess('products')){
			if(isset($_POST['title']) && $_POST['title'] != ''){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->cms->generateFriendlyUrl($_POST['friendlyurl']);
				}else{
					if($_POST['title'] != ''){
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['title']);
					}else{
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['name']);
					}
				}
				
				$data=array('idproducts_languages' => '',
							'idproducts' => $idproduct,
							'idlanguages' => $_POST['idlanguage'],
							'name' => $_POST['name'],
							'content' => $_POST['artcontent'],
							'title' => $_POST['title'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],
							'additional_data' => $_POST['additional_data'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->add_product_language($data);
				redirect('/admin/products', 'location');	
			}else{
				$data['id_articles'] = $idproduct;
				//przygotowanie listy jezykow do boxa
				$used_langs = $this->admin_model->get_product_languages_by_idproducts($idproduct);
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$flag = 1;
					foreach($used_langs as $used_lang){
						if($lang['idlanguages'] == $used_lang['idlanguages'])
						{
							$flag = 0;
							break;
						}
					}
					if($flag){
						$bufor1[$i]=$lang['idlanguages'];
						$bufor2[$i]=$lang['shortname'];
						$i++;
					}
				}	
				if($bufor1!=array() && $bufor2!=array()){			
					$data['languages']=array_combine($bufor1,$bufor2);		
					$data['meta'] = $this->metatags->getValue('product',$idlang);
					$data['content'] = $this->load->view('admin/add_product_language', $data, true);
				}else{
					$data['content'] = $this->localization['wszystkie_wersje_dostepne'];
				}
				
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}
	
	function edit_product_language($idlang = 3){
		$data2 = $this->cms->getMenus('products');
		if($this->auth->hasAccess('products')){
			if(isset($_POST['title']) && $_POST['title'] != ''){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->cms->generateFriendlyUrl($_POST['friendlyurl']);
				}else{
					if($_POST['title'] != ''){
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['title']);
					}else{
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['name']);
					}
				}
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
				
				$idarticle_languages = $_POST['idarticle_languages'];
				
				if(isset($_FILES) && $_FILES['file']['name']!=''){
					$photo = $this->admin_model->get_product_by_id($_POST['idarticles']);
					if(isset($photo[0]) && $photo[0]['photo']!=''){
						unlink('./files/img/products/'.$photo[0]['photo']);
						unlink('./files/img/products/min/'.$photo[0]['photo']);
					}
					//uploadowanie pliku
					$config['upload_path'] = './files/img/products/';
					$config['allowed_types'] = 'gif|jpg|png';
					$config['remove_spaces'] = TRUE;		
					
					$this->load->library('upload', $config);
					$this->upload->do_upload('file');
					$file_data = $this->upload->data();
					
					//tworzenie miniaturki
					$img_config['image_library'] = 'GD2';
					$img_config['source_image'] = './files/img/products/'.$file_data['file_name'];
					$img_config['new_image'] = './files/img/products/min/';
					$img_config['maintain_ratio'] = TRUE;
					$img_config['width'] = $this->product['width'];
					$img_config['height'] = $this->product['height'];
					$this->load->library('image_lib', $img_config);
					$this->image_lib->resize();
					if ( ! $this->image_lib->resize()){
					    echo $this->image_lib->display_errors();
					}	
					$data = array('photo'=> $file_data['file_name']);
					$this->admin_model->update_product($_POST['idarticles'], $data);
				}
									
				$data=array('active' => $active);
				$this->admin_model->update_product($_POST['idarticles'], $data);
				
				$data=array('idlanguages' => $_POST['idlanguage'],
							'name' => $_POST['name'],
							'content' => $_POST['artcontent'],
							'title' => $_POST['title'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],							
							'additional_data' => $_POST['additional_data'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->update_product_language($idarticle_languages, $data);
				
				redirect('/admin/products', 'location');	
			}else{
				$idarticle_languages = $_POST['idproduct_languages'];
				//przygotowanie danych
				$article = $this->admin_model->get_product_lang_by_id($idarticle_languages);
				if(isset($article[0])){
					$article = $article[0];	
					
					$data = array(	'idarticle_languages' => $idarticle_languages,
									'idarticles' => $article['idproducts'],
									'title' => $article['title'],
									'content' => $article['content'],
									'titleseo' => $article['titleseo'],
									'keywords' => $article['keywords'],
									'shortdesc' => $article['shortdesc'],
									'abstract' => $article['abstract'],
									'subject' => $article['subject'],
									'topic' => $article['topic'],
									'copyrights' => $article['copyrights'],
									'friendlyurl' => $article['friendlyurl'],
									'additional_data' => $article['additional_data'],
									'active' => $article['active']
								);		
					
					//przygotowanie listy jezykow do boxa
					$languages = $this->admin_model->get_languages();
					$bufor1=array($article['idlanguages']);
					$bufor2=array('---');
					$i = 1;
					foreach($languages as $lang){
						$bufor1[$i]=$lang['idlanguages'];
						$bufor2[$i]=$lang['shortname'];
						$i++;
					}
					$data['languages']=array_combine($bufor1,$bufor2);
					
					$data2['content'] = $this->load->view('admin/edit_product_language', $data, true);
					
					$metatags = $this->metatags->getValue('cms',$idlang);
					$this->load->view('_shared/layouts/cms/header', $metatags);
					$this->load->view('_shared/layouts/cms/admin',$data2);
				}else{
					redirect('/admin/products', 'location');
				}
			}
		}	
	}

	function set_subproducts($idparent){
		if($this->auth->hasAccess('products'))
                {
			//print_r($_POST);
			$subproducts = $this->admin_model->get_products_by_cat_name('Elementy');
			//print_r($subproducts);
				foreach($subproducts as $subproduct){
					if(isset($_POST[$subproduct['name']])){
						$isInDB = $this->admin_model->get_subproduct_by_parent_by_child($idparent,$subproduct['idproducts']);
						if(!isset($isInDB[0])){
							$data = array(	'idsubproducts' => '',
											'idparent' => $idparent,
											'idchild' => $subproduct['idproducts']
										);
							$this->admin_model->add_subproduct($data);
						}
					}else{
						$isInDB = $this->admin_model->get_subproduct_by_parent_by_child($idparent,$subproduct['idproducts']);
						if(isset($isInDB[0])){
							$this->admin_model->delete_subproduct_by_parent_by_child($idparent,$subproduct['idproducts']);
						}
					}
				}
		}				
		redirect('/admin/products', 'location');
	}

	function add_product_category($idlang = 3){
		$data = $this->cms->getMenus('products');
		if($this->auth->hasAccess('products')){
			if(isset($_POST['title']) && $_POST['title'] != ''){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->cms->generateFriendlyUrl($_POST['friendlyurl']);
				}else{
					if($_POST['title'] != ''){
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['title']);
					}else{
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['name']);
					}
				}
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}		
				$data=array('idproduct_categories' => '',
							'type' => $_POST['title']
				);
				$this->admin_model->add_product_category($data);
				$idadded_product = $this->db->insert_id();
				$data=array('idproduct_categories_languages' => '',
							'idproduct_categories' => $idadded_product,
							'idlanguages' => $_POST['idlanguage'],
							'name' => $_POST['name'],
							'content' => $_POST['artcontent'],
							'title' => $_POST['title'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],			
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->add_product_category_language($data);	
				
				redirect('/admin/products', 'location');	
			}else{
				//przygotowanie listy jezykow do boxa
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$bufor1[$i]=$lang['idlanguages'];
					$bufor2[$i]=$lang['shortname'];
					$i++;
				}
				
				$data['languages']=array_combine($bufor1,$bufor2);
				
				//$data['meta'] = $this->metatags->getValue('article',$idlang);
				$data['content'] = $this->load->view('admin/add_product_category', $data, true);
				
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}
	
	function add_product_category_language($id, $idlang = 3){
		$data = $this->cms->getMenus('products');
		if($this->auth->hasAccess('products')){
			if(isset($_POST['title']) && $_POST['title'] != ''){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->cms->generateFriendlyUrl($_POST['friendlyurl']);
				}else{
					if($_POST['title'] != ''){
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['title']);
					}else{
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['name']);
					}
				}
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}	
				$data=array('idproduct_categories_languages' => '',
							'idproduct_categories' => $id,
							'idlanguages' => $_POST['idlanguage'],
							'name' => $_POST['name'],
							'content' => $_POST['artcontent'],
							'title' => $_POST['title'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],			
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->add_product_category_language($data);	
				
				redirect('/admin/products', 'location');	
			}else{
				$data['idproduct_categories'] = $id;
				$data['idlanguage'] = $_POST['idlanguage'];
				//$data['meta'] = $this->metatags->getValue('article',$idlang);
				$data['content'] = $this->load->view('admin/add_prod_cat_language', $data, true);
				
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}
	
	function edit_product_category_language($idlang = 3){
		$data = $this->cms->getMenus('products');
		if($this->auth->hasAccess('products')){
			if(isset($_POST['title']) && $_POST['title'] != ''){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->cms->generateFriendlyUrl($_POST['friendlyurl']);
				}else{
					if($_POST['title'] != ''){
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['title']);
					}else{
						$friendlyurl = $this->cms->generateFriendlyUrl($_POST['name']);
					}
				}
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
					
				$id = $_POST['idproduct_categories_languages'];
				$data=array(
							'name'      => $_POST['name'],
							'content'   => $_POST['artcontent'],
							'title'     => $_POST['title'],
							'keywords'  => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract'  => $_POST['abstract'],
							'subject'   => $_POST['subject'],
							'topic'         => $_POST['topic'],
							'copyrights'    => $_POST['copyrights'],
							'friendlyurl'   => $friendlyurl
				);
				$this->admin_model->update_product_category_language($id, $data);	
				
				redirect('/admin/products', 'location');	
			}else{
				$id = $_POST['idproduct_categories_languages'];
				$data['idproduct_categories'] = $id;
				$categories = $this->admin_model->get_product_category_language($id);
				if(isset($categories[0])){
					$data['content'] = $this->load->view('admin/edit_prod_cat_language', $categories[0], true);
				}else{
					$data['content'] = 'Wystapił błąd. Przepraszamy';
				}
				
				$metatags = $this->metatags->getValue('cms',$idlang);
				$this->load->view('_shared/layouts/cms/header', $metatags);
				$this->load->view('_shared/layouts/cms/admin',$data);
			}
		}					
	}
	
	function delete_product_category_language($idcategory){
		if($this->auth->hasAccess('products')){
			$idcategory_languages = $_POST['idproduct_languages'];
			$this->admin_model->delete_prod_cat_language($idcategory_languages);
			$data = $this->admin_model->get_prod_cat_languages_by_idcategory($idcategory);
			if(!isset($data[0])){
				$deleted_categories = $this->admin_model->get_prod_prod_cat_idcategory($idcategory);
				
				if(isset($deleted_categories[0])){
					foreach($deleted_categories as $deleted_category){
						$deleted_product = $this->admin_model->get_product_by_id($idproduct);
						$this->admin_model->delete_subproduct_by_idparent($deleted_category['idproduct']);	
						$this->admin_model->delete_subproduct_by_idchild($deleted_category['idproduct']);	
						$this->admin_model->delete_product_product_category_by_idproduct($deleted_category['idproduct']);
						$this->admin_model->delete_product_languages_by_idproduct($deleted_category['idproduct']);	
						$this->admin_model->delete_product($deleted_category['idproduct']);	
						if(isset($deleted_product[0])){
							if($deleted_product[0]['photo']!=''){
								unlink('./files/img/products/'.$deleted_product[0]['photo']);
								unlink('./files/img/products/min/'.$deleted_product[0]['photo']);
							}
						}
					}
				}
				$this->admin_model->delete_product_category($idcategory);	
			}
		}
		redirect('/admin/products', 'location');	
	}

	function change_product_gallery($id){
		if($this->auth->hasAccess('products')){
			$data=array( 'idgalleries' => $_POST['idgallery']);
			$this->admin_model->update_product($id, $data);
		}
		redirect('/admin/products', 'location');
	}

    function change_article_gallery($id){
		if($this->auth->hasAccess('articles')){
			$data=array( 'idgalleries' => $_POST['idgallery']);
			$this->admin_model->update_article($id, $data);
		}
		redirect('/admin/articles', 'location');
	}
	
    function guest_book($idlang=3,$id=null)
    {
            if(!$this->auth->hasAccess('newses'))
                show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));

            //kasowanie wpisu w ksiedze gosci
            if(!empty($id))
            {
                    $this->admin_model->del_guest($id);
            }

            $list['guests'] = $this->admin_model->get_all_guests();
            //$list['news_languages'] = $this->admin_model->get_news_languages();

            $data = $this->cms->getMenus('guests_book');
            $data['content'] = $this->load->view('admin/guests_book', $list, true);

            $metatags = $this->metatags->getValue('cms',$idlang);
            $this->load->view('_shared/layouts/cms/header', $metatags);
            $this->load->view('_shared/layouts/cms/admin',$data);
    }
    //--------------------------------------------------------------------------
    function lists($idlang=3)
    {
        if(!$this->auth->hasAccess('lists'))
            show_custom_error(ucfirst($this->localization['wystapil_blad']), ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']));


        $data                   = $this->cms->getMenus('lists');
        $viewData['lists']      = $this->list_model->getTree();
        
        $data['content']        = $this->load->view('admin/lists', $viewData, true);
        
        $metatags = $this->metatags->getValue('cms',$idlang);
        $this->load->view('_shared/layouts/cms/header', $metatags);
        $this->load->view('_shared/layouts/cms/admin',$data);
    }
    //--------------------------------------------------------------------------
    function add_list_item($idlang=3)
    {
        $data   = $this->cms->getMenus('lists');
      
        if($this->auth->hasAccess('lists'))
        {

            if(!empty($_POST))
            {
                $this->load->library('form_validation');
                $this->lang->switch_to('polish');

                $this->form_validation->set_error_delimiters('<span class="error">', '</span>');
                $this->form_validation->set_rules('name', 'Nazwa', 'required');
                $this->form_validation->set_rules('description', 'Opis', '');
                $this->form_validation->set_rules('link', 'Link', '');
                $this->form_validation->set_rules('image', 'Obrazek', '');
                $this->form_validation->set_rules('param1', 'Param 1', '');
                $this->form_validation->set_rules('param2', 'Param 2', '');
                $this->form_validation->set_rules('param3', 'Param 3', '');
                $this->form_validation->set_rules('param4', 'Param 4', '');

                $this->form_validation->set_rules('parent_id', 'Kategoria nadrzędna', 'integer');
                $this->form_validation->set_rules('show_order', 'Kolejność', 'integer');
                $this->form_validation->set_rules('id_galleries', 'Galeria', 'integer');

                if($this->form_validation->run() == TRUE)
                {
                    //nullable fields
                    $parent_id                  =   set_value('parent_id');
                    $id_galleries               =   set_value('id_galleries');
                    $link                       =   set_value('link');

                    $param1                     =   set_value('param1');
                    $param2                     =   set_value('param2');
                    $param3                     =   set_value('param3');
                    $param4                     =   set_value('param4');


                    if(isset($_FILES['image']) && $_FILES['image']['name']!=''){
                        //uploadowanie pliku
                        $config['upload_path'] = './files/img/lists/';
                        $config['allowed_types'] = 'gif|jpg|png';
                        $config['remove_spaces'] = TRUE;

                        $this->load->library('upload', $config);
                        if($this->upload->do_upload('image'))
                        {
                            $file_data = $this->upload->data();
                            //zmiana praw pliku
                            chmod('./files/img/lists/'.$file_data['file_name'], 0777);
                            rename('./files/img/lists/'.$file_data['file_name'], './files/img/lists/'.date("Y_m_d-H_i_s_u").".jpg");
                            $item['image']      = '/files/img/lists/'.date("Y_m_d-H_i_s_u").".jpg";
                        }
                    }

                    //------------------------------------------------------
                    $item['name']           =   set_value('name');
                    $item['description']    =   set_value('description');

                    $item['description']    = trim($item['description']);
                    if($item['description'] == '<br />' || $item['description'] == '<br/>' || $item['description'] == '&lt;br /&gt;')
                        $item['description']  = null;

                    $item['parent_id']      =   empty($parent_id) ? null : set_value('parent_id');
                    $item['link']           =   empty($link) ? null : set_value('link');
                    $item['param1']         =   empty($param1) ? null : set_value('param1');
                    $item['param2']         =   empty($param2) ? null : set_value('param2');
                    $item['param3']         =   empty($param3) ? null : set_value('param3');
                    $item['param4']         =   empty($param4) ? null : set_value('param4');

                    $item['show_order']     =   set_value('show_order');
                    $item['id_galleries']   =   empty($id_galleries) ? null : set_value('id_galleries');

                    if($this->list_model->create($item))
                       redirect('admin/lists','location');
                    else
                        $data['message'] = "Wystąpił błąd";
                }
            }
            
            $data['lists']              = $this->list_model->getAll();
            $data['galleries']          = $this->admin_model->get_galleries();
            $data['content']            = $this->load->view('admin/add_list_item', $data, true);
        }
        else
           $data['content'] = ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']);

        $metatags        = $this->metatags->getValue('cms',$idlang);
        $this->load->view('_shared/layouts/cms/header', $metatags);
        $this->load->view('_shared/layouts/cms/admin',$data);
    }
    //--------------------------------------------------------------------------
    function edit_list_item($id,$idlang = 3)
    {
        $data                       = $this->cms->getMenus('lists');

        if($this->auth->hasAccess('lists'))
        {
            $data['list_item']   = $this->list_model->getById($id);
            if(!empty($_POST))
            {
                $this->load->library('form_validation');
                $this->lang->switch_to('polish');

                $this->form_validation->set_error_delimiters('<span class="error">', '</span>');
                $this->form_validation->set_rules('name', 'Nazwa', 'required');
                $this->form_validation->set_rules('description', 'Opis', '');
                $this->form_validation->set_rules('link', 'Link', '');

                $this->form_validation->set_rules('param1', 'Param1', '');
                $this->form_validation->set_rules('param2', 'Param2', '');
                $this->form_validation->set_rules('param3', 'Param3', '');
                $this->form_validation->set_rules('param4', 'Param4', '');

                $this->form_validation->set_rules('parent_id', 'Kategoria nadrzędna', 'integer');
                $this->form_validation->set_rules('show_order', 'Kolejność', 'integer');
                $this->form_validation->set_rules('id_galleries', 'Galeria', 'integer');

                if($this->form_validation->run() == TRUE)
                {
                    $parent_id                  =   set_value('parent_id');
                    $id_galleries               =   set_value('id_galleries');
                    $link                       =   set_value('link');
                    //----------------------------------------------------------
                    if(isset($_FILES['image']) && $_FILES['image']['name']!=''){
                        //uploadowanie pliku
                        $config['upload_path'] = './files/img/lists/';
                        $config['allowed_types'] = 'gif|jpg|png';
                        $config['remove_spaces'] = TRUE;

                        $this->load->library('upload', $config);
                        if($this->upload->do_upload('image'))
                        {
                            $file_data = $this->upload->data();
                            //zmiana praw pliku
                            chmod('./files/img/lists/'.$file_data['file_name'], 0777);
                            rename('./files/img/lists/'.$file_data['file_name'], './files/img/lists/'.date("Y_m_d-H_i_s_u").".jpg");
                            $item['image']      = '/files/img/lists/'.date("Y_m_d-H_i_s_u").".jpg";
                        }
                    }


                    $item['name']           =   set_value('name');
                    $item['description']    =   set_value('description');

                    $item['link']           =   empty($link) ? null : set_value('link');

                    $item['param1']           =   empty($link) ? null : set_value('param1');
                    $item['param2']           =   empty($link) ? null : set_value('param2');
                    $item['param3']           =   empty($link) ? null : set_value('param3');
                    $item['param4']           =   empty($link) ? null : set_value('param4');

                    $item['description']    = trim($item['description']);
                    if($item['description'] == '<br />' || $item['description'] == '<br/>' || $item['description'] == '&lt;br /&gt;')
                        $item['description']  = null;

                    $item['parent_id']      =   empty($parent_id) ? null : set_value('parent_id');
                    $item['show_order']     =   set_value('show_order');
                    $item['id_galleries']   =   empty($id_galleries) ? null : set_value('id_galleries');

                    //----------------------------------------------------------
                    $data['list_item']->parent_id       = $item['parent_id'];
                    $data['list_item']->name            = $item['name'];
                    $data['list_item']->description     = $item['description'];
                    $data['list_item']->link            = $item['link'];

                    $data['param1']->link            = $item['param1'];
                    $data['param2']->link            = $item['param2'];
                    $data['param3']->link            = $item['param3'];
                    $data['param4']->link            = $item['param4'];

                    $data['list_item']->show_order      = $item['show_order'];
                    $data['list_item']->id_galleries    = $item['id_galleries'];

                    if($this->list_model->update($id,$item))
                       redirect('admin/lists','location');
                    else
                        $data['message'] = "Wystąpił błąd";
                }
            }


            $data['lists']              = $this->list_model->getAll();
            $data['galleries']          = $this->admin_model->get_galleries();
            $data['content']            = $this->load->view('admin/edit_list_item', $data, true);
        }
        else
           $data['content'] = ucfirst($this->localization['nie_masz_uprawnien_do_tego_zasobu']);

        $metatags        = $this->metatags->getValue('cms',$idlang);
        $this->load->view('_shared/layouts/cms/header', $metatags);
        $this->load->view('_shared/layouts/cms/admin',$data);
    }
    //--------------------------------------------------------------------------
    function delete_list_item($id)
    {
        if($this->auth->hasAccess('lists'))
        {        
            $id = (int)$id;
            $this->list_model->delete($id);
        }
        redirect('admin/lists','location');
    }
    //--------------------------------------------------------------------------
    function delete_list_item_image($id)
    {
        if($this->auth->hasAccess('lists'))
        {        
            $id                 = (int)$id;
            $list_item   = $this->list_model->getById($id);

            if(!empty($list_item->image))
                unlink('.'.$list_item->image);

            $item['image']      =  '';
            $this->list_model->update($id,$item);
        }
        redirect('admin/lists','location');
    }
    //--------------------------------------------------------------------------
    function xxx()
    {
        $langs                  = (array)$this->admin_model->get_languages();
        if(!empty($langs) && is_array($langs))
        {
            foreach($langs as $k=>$v)
                echo $v['idlanguages']."<br/>";
        }
    }
}
?>