$(document).ready(function(){
    $.ajaxSetup({ cache: false });

    var dontSort = [];
    $('#data_table thead th').each( function () {
            if ( $(this).hasClass( 'no_sort' )) {
                    dontSort.push( { "bSortable": false } );
            } else {
                    dontSort.push( null );
            }
    });

    $('#data_table').dataTable(
        {
            "aoColumns": dontSort,
            "sPaginationType": "full_numbers",
            "oLanguage": {
                "sUrl": "/files/js/datatables-1.7.6/media/internationalisation/dataTables.polish.txt"
            }
        }
    );

    $('table.dragable').tableDnD({
        onDragClass: "drag",
        onDrop: function(table, row)
        {
            //alert($('#table-5').tableDnDSerialize());
            //alert($.tableDnD.serialize());
            var url = $('table.dragable').data('dragurl');
            if(url != null)
                {
                    $.post(url,$.tableDnD.serialize(),function(data){
                        if(data == 0)
                            alert('An error occurred, please try again later');
                    });
                }
            jQuery("tr:even",table).removeClass('odd').addClass('even');
            jQuery("tr:odd",table).removeClass('even').addClass('odd');
        }});
    

    $('.delete_link').click(function(){
        return (confirm("Czy na pewno chcesz usunąć wskazany element?"));
    });

});

//dodanie komponentu tinyMCE do formularza w miejsce textarea
function addTinyMCE() {
    tinyMCE.init({
        theme:      "advanced",
        mode:       "textareas",
        plugins:    "fullscreen",
        theme_advanced_buttons1_add: "fullscreen",
        theme_advanced_toolbar_location: "top",
        theme_advanced_toolbar_align: "left",
        relative_urls: false,
        force_p_newlines: false,
        force_br_newlines: true,
        forced_root_block: false
    });
}


function get_json_meta_types()
{
    var idlanguage = document.dataform.idlanguage.value;

    var link ="/admin/get_json_meta_types/"+idlanguage;
    $.post(link, null, wypelnij, "json");
    function wypelnij(data)
    {
            $("#idmetatags").html(data.content);
            get_metatags();
    }
}

function get_metatags()
{
    var idmetatags = document.dataform.idmetatags.value;

    var link ="/admin/get_json_meta/"+idmetatags;
    $.post(link, null, wypelnij, "json");

    function wypelnij(data)
    {
            $("#keywords").val(data.keywords);
            $("#shortdesc").val(data.shortdesc);
            $("#abstract").val(data.abstract);
            $("#subject").val(data.subject);
            $("#topic").val(data.topic);
            $("#copyrights").val(data.copyrights);
    }
}


